#include "mbed.h" 
#include "QEI.h"      // Librería del ENCODER GIRATORIO("potenciómetro"+PULSADOR)
#include "TextLCD.h"    // LCD 
#include "DebouncedIn.h"
#include "stdio.h"      //printf, etc
#include "string.h"
#include "stdlib.h"     // atoi
#include "stdint.h"
#include <assert.h>

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
QEI encoder (PTA13, PTD5, NC, 624);
AnalogIn y(PTB3);           //entrada analoga
AnalogOut u(PTE30);         //salida analoga (Imax=1,5mA!!!!)
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);

DigitalIn button4(PTC17);//termina y consolida valores de 4 parametros y sale del loop

//****************** CONFIGURACIÓN DE PUERTOS DE COMUNICACIÓN ******************
Serial BLUETOOTH(PTE0,PTE1);  //puertos USART del FRDM para el módulo BLUETOOTH
Serial pc(USBTX,USBRX);

//********************************** VARIABLES *********************************
int cambio=0, diferencia=0;
float pid,o,ai,ad,ap,med,err;
float err_v;
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1;
int i,ret;
int n=0;
char *ptr;
char bufferllegada[100];
char bufferenvio[100];
Timer t;

//********************************** FUNCIONES *********************************
//*********************** LECTURA BUFFER - INTERRUPCIONES **********************
int readBuffer(char *buffer,int count){
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (BLUETOOTH.readable()) {
            char c = BLUETOOTH.getc();
            if (c == '\r' || c == '\n') c = '\0';
            buffer[i++] = c;
            if(i > count)break;
            }
            if(i > count)break;
            if(t.read() > 1) {
                t.stop();
                t.reset();
                break;
                }
        }
    wait(0.5);
    while(BLUETOOTH.readable()) { 
        char c = BLUETOOTH.getc();
        }
    return 0;
    }

//****************************** BORRADO DE BUFFER *****************************
void cleanBuffer(char *buffer, int count){
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
//******************** SPLIT A STRING BY PARSING STRINGS BY ; ******************


int dtmsplit(char *str, const char *delim, char ***array, int *length ) {
  int i=0;
  char *token;
  char **res = (char **) malloc(0 * sizeof(char *));

  /* get the first token */
   token = strtok(str, delim);
   while( token != NULL )
   {
        res = (char **) realloc(res, (i + 1) * sizeof(char *));
        res[i] = token;
        i++;
      token = strtok(NULL, delim);
   }
   *array = res;
   *length = i;
  return 1;
}


//******************************************************************************
//******************************* CICLO PRINCIPAL ******************************
//******************************************************************************
int main()
{
    //***************************** BAUDIOS Y BITS *****************************
    BLUETOOTH.baud(9600);
    BLUETOOTH.format(8,Serial::None,1);
    
    lcd.locate(0,1);
    lcd.printf("**Control PID**");
    pc.printf("**Control PID**\r\n");
    wait(2);
    lcd.cls(); // Borrar Pantalla
    lcd.locate(0,0);
    lcd.printf("Esperando datos...");
    pc.printf("Esperando datos...\r\n");
    
    while(1){
        if (BLUETOOTH.readable()) {
            readBuffer(bufferllegada,100);
            if(NULL != ( ptr = strstr(bufferllegada,"SP"))){
                printf("Buffer original = [%s] \n\n", bufferllegada);
                //******************** PARTIENDO LA CADENA *********************
                int i;
                char **arr = NULL;
                int count =0;
                int c = dtmsplit(bufferllegada, ";", &arr, &count);
                pc.printf("Found %d tokens.\n", count);
                for (i = 0; i < count; i++){
                    pc.printf("string #%d: %s\n", i, arr[i]);
                    }
                pc.printf("SP-string=%s\n",arr[1]);
                pc.printf("KP-string=%s\n",arr[3]);
                pc.printf("KI-string=%s\n",arr[5]);
                pc.printf("KD-string=%s\n",arr[7]);
                pc.printf("\n");
                spnum=atoi(arr[1]);          //atoi ->  Convert string to integer C++
                kpnum=atoi(arr[3]);
                kinum=atoi(arr[5]);
                kdnum=atoi(arr[7]);
                pc.printf("SP=%i\n",spnum);
                pc.printf("KP=%i\n",kpnum);
                pc.printf("KI=%i\n",kinum);
                pc.printf("KD=%i\n",kdnum);
                pc.printf("\n");
                free(arr);
                }   //end if(NULL != ( ptr1 = strstr(buffer,"SP"))){
                // My code (tested) in http://stackoverflow.com/questions/9210528/split-string-with-delimiters-in-c
                // http://stackoverflow.com/questions/9054553/atoi-from-string-to-integer-using-char-pointer
                // https://www.tutorialspoint.com/cprogramming/c_pointers.htm
            // Impresión de cada parámetros en LCD
            lcd.cls(); // Borrar Pantalla
            // Imprime SP
            lcd.locate(0,0);
            lcd.printf("Sp=%d",spnum);
            lcd.locate(3,0);                // necesariamente (columna, fila)
            lcd.printf("    ");
            lcd.locate(3,0);
            lcd.printf("%d", spnum);
            // Imprime KP
            lcd.locate(8,0);                
            lcd.printf("Kp=%d",kpnum);
            lcd.locate(11,0);
            lcd.printf("    ");
            lcd.locate(11,0);
            lcd.printf("%d", kpnum);
            // Imprime KI
            lcd.locate(0,1);
            lcd.printf("Ki=%d",kinum);
            lcd.locate(3,1);
            lcd.printf("    ");
            lcd.locate(3,1);
            lcd.printf("%d", kinum);
            // Imprime KD
            lcd.locate(8,1);
            lcd.printf("Kd=%d",kdnum);
            lcd.locate(11,1);
            lcd.printf("    ");
            lcd.locate(11,1);
            lcd.printf("%d", kdnum);
            }   //Fin if (BLUETOOTH.readable()) {
                
            if (!button4){
                wait(0.1); 
                break;     //sale del bucle si pisan suiche4
                }
    }   // FIN while(1)            
    

//Transicion
    lcd.cls(); //borra la pantalla
    lcd.printf("   GUARDADOS!");
    pc.printf("   GUARDADOS!\r\n");
    wait(1);
    lcd.cls();
    lcd.printf(" INICIA EL PID");
    pc.printf(" INICIA EL PID\r\n");
    wait(1);
// se imprimen los parches del control  *****************************************
    lcd.cls();
    lcd.printf("Er=%3.0f",err);
    lcd.locate(8,0);
    lcd.printf("Me=%3.0f",med);
    lcd.locate(0,1);
    lcd.printf("Sp=%3.0f",spnum);
    lcd.locate(8,1);
    lcd.printf("Co=%3.0f",pid);
    wait(1);

// CICLO PRINCIPAL CONTROLADOR PID

 while(1){
        med = y.read()*999;
        err = (spnum-med);  //se calcula el error
        ap = kpnum*err*0.01f;     //se calcula la accion proporcinal
        ai =(kinum*err*0.01f)+ai;    //calculo de la integral del error
        ad = kdnum*(err-err_v)*0.01f; //calculo de la accion derivativa
        pid = (ap+ai+ad); 
        
        // se verifica que pid sea positivo **************************************
        if(pid<=0){
            pid=0;
        }
        // se verifica que pid sea menor o igual la valor maximo *****************
        if (pid > 999){
            pid=999;
        }
        //se muestran las variables******************************************
            lcd.locate(3,0);
            lcd.printf("    ");
            lcd.locate(3,0);
            lcd.printf("%3.0f",err);
            lcd.locate(11,0);
            lcd.printf("   ");
            lcd.locate(11,0);
            lcd.printf("%3.0f",med);
            lcd.locate(3,1);
            lcd.printf("   ");
            lcd.locate(3,1);
            lcd.printf("%d",spnum);
            lcd.locate(11,1);
            lcd.printf("   ");
            lcd.locate(11,1);
            lcd.printf("%3.0f",pid);
            
            /*
            pc.printf("Er=%3.0f\r\n",err);
            pc.printf("Me=%3.0f\r\n",med);
            pc.printf("Sp=%3.0f\r\n",spnum);
            pc.printf("Co=%3.0f\r\n",pid);
            */     
        //Normalizacion de la salida
        // se actualizan las variables *******************************************
        //  se envia el valor pid a puerto analogico de salida (D/A) **************
        err_v = err;
        o = pid/999;
        u.write(o);
        
        //  se repite el ciclo
        wait_ms(30);
        
        //****************** CONCATENA Y ENVÍA POR BLUETOOTH *******************
        cleanBuffer(bufferllegada,100);
        cleanBuffer(bufferenvio,100);
        
        char str1[]="SEND";
        char buf1[10];
        char buf2[10];
        char buf3[10];
        char buf4[10];
        
        sprintf(buf1,"%3.0f",err);
        sprintf(buf2,"%3.0f",med);
        sprintf(buf3,"%i",spnum);
        sprintf(buf4,"%3.0f",pid);
        strcpy (bufferenvio,str1);
        strcat (bufferenvio,";");
        strcat (bufferenvio,buf1);
        strcat (bufferenvio,";");
        strcat (bufferenvio,buf2);
        strcat (bufferenvio,";");
        strcat (bufferenvio,buf3);
        strcat (bufferenvio,";");
        strcat (bufferenvio,buf4);
        strcat (bufferenvio,";");
        pc.printf("Datos a enviar= %s\r\n",bufferenvio);
        BLUETOOTH.printf("%s\r\n", bufferenvio);
        
        // se envía algo del tipo SEND;XXX.XX;XXX.XX;XXX;XXX.XX
        // al usar SPLIT por ; se tienen 5 elementos
}
}
