/*
 *
 */

#ifndef _PARSER_H_
#define _PARSER_H_

#include "string"
#include "list"

#define WRAP_SEND   1
#define WRAP_ABORT  2
#define WRAP_FINISHED  3

#define HEADER_CHAR 'A'
#define FOOTER_CHAR 'B'
#define DLE_CHAR '+'

void unwrap_protocol(char *, string *buffer, list<string> *messages,
                     unsigned int max_message_size = 255, unsigned int max_message = 5,
                     char header=HEADER_CHAR, char footer=FOOTER_CHAR, char dle=DLE_CHAR);


int wrap_protocol(char *c, string *buffer, list<string> *messages,
                   char header=HEADER_CHAR, char footer=FOOTER_CHAR, char dle=DLE_CHAR);


// these have to be declared somewhere else for consistency
extern DigitalOut message_led;


#endif
