/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : main.cpp
* Authors   : JS Wu - CPBG (js.wu@cyntec.com)
* Version   : V.1.0.0
* Date      : 2017/Mar/03
*
* This example shows how to enable WiFi chip, and disable the interface between
* BLE & WiFi of NNN50, thus the external Host MCU can use SPI interface to 
* control WiFi under linux base OS
*
*******************************************************************************/

#include "mbed.h"
#include "EthernetInterface.h"
#include "WIFIDevice.h"

DigitalOut myled(p13);

DigitalOut WiFi_en(p8);
DigitalOut WiFi_reset_n(p10);
DigitalOut WiFi_wake(p18);
DigitalOut RF_control_1(p19);
DigitalOut RF_control_2(p28);
DigitalIn SPI_SSN(p12);
DigitalIn SPI_MISO(p9);
DigitalIn SPI_MOSI(p15);
DigitalIn SPI_CLK(p11);
DigitalIn SPI_IRQ(p14);

int main() {

    //config WiFi pins
    WiFi_en = 1;
    WiFi_wake = 1;
    WiFi_reset_n = 1;       //make a Reset signal
    wait(0.3);
    WiFi_reset_n = 0;
    wait(0.5);
    WiFi_reset_n = 1;
    wait(0.3);
    
    //config RF path to WiFi
    RF_control_1 = 1;
    RF_control_2 = 0;

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
