/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : main.cpp
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.0
* Date      : 2016/Nov/24
*
* This example only show the most basic WiFi operation include AP scan and connect 
* The usage of TCP/UDP socket please refer to the mbed Handbook from the link below
* https://developer.mbed.org/handbook/Socket
*
*******************************************************************************/

#include "mbed.h"
#include "EthernetInterface.h"
#include "WIFIDevice.h"

#if 1
const char* ECHO_SERVER_ADDRESS = "192.168.100.2";
char* AP_SSID = "HAME_A2_a5d1";
char* PASSWD  = "12345678";
const int ECHO_SERVER_PORT = 5001;
#else
const char* ECHO_SERVER_ADDRESS = "172.20.10.4";
char* AP_SSID = "Gaan";
char* PASSWD  = "12348888";
const int ECHO_SERVER_PORT = 5001;
#endif

Serial uart(p17, p16);//temporary define for alpha release

int main() {

    EthernetInterface eth;
    WIFIDevice wifi;
    
    uart.baud(9600);
    
    eth.init();
    uart.printf("MAC: %s\n", eth.getMACAddress());

    //wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, "Tsungta_iPhone", "icq87001"); 
    //wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, "Gaan", "12348888"); 
    wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, AP_SSID, PASSWD);
    
    eth.connect();
    printf("IP: %s\n", eth.getIPAddress());
    printf("Gateway: %s\n", eth.getGateway());
    printf("NetworkMask: %s\n", eth.getNetworkMask());

    if(wifi.is_AP_connected())
        uart.printf("Connect Success! \n");
    else
        uart.printf("Connect Fail! \n");     

    UDPSocket sock;
    sock.init();
    
    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    
    char out_buffer[1400] = "Hello World";
    uart.printf("Sending  message '%s' to server (%s)\n",out_buffer,ECHO_SERVER_ADDRESS);
    while(1)
        sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));
    
    sock.close();
    
    eth.disconnect();                             
    
    wifi.sleep();
                                 
    while(1) {
    }
}

