#include "mbed.h"

Serial pc(USBTX, USBRX);

static char serial_buffer[1024] = { 0 };
static uint32_t serial_ix = 0;
static bool serial_line_ready = false;
static bool button_pressed = false;
static uint32_t button_count = 0;

static DigitalOut led(LED1);
static InterruptIn btn(BUTTON1);

void rx_irq() {
    char c = pc.getc();

    if (c == '\r') {
        serial_line_ready = true;
    }
    else if (c == '\n') {
        return;
    }
    else {
        serial_buffer[serial_ix] = c;

        serial_ix++;
    }

    if (serial_ix >= 1023) {
        memset(serial_buffer, 0, 1024);
        serial_ix = 0;
    }
}

void btn_irq() {
    button_pressed = true;
    button_count++;
}

int main() {
    pc.baud(115200);
    pc.printf("!Hello from proprietary serial device #1\r\n");

    pc.attach(callback(&rx_irq));
    btn.fall(callback(&btn_irq));

    while (1) {
        if (serial_line_ready) {
            if (strcmp(serial_buffer, "+LED1") == 0) {
                led = 1;
                printf(">%s\r\n!LED1 is now on\r\n", serial_buffer);
            }
            else if (strcmp(serial_buffer, "-LED1") == 0) {
                led = 0;
                printf(">%s\r\n!LED1 is now off\r\n", serial_buffer);
            }
            else {
                printf(">%s\r\n!Unknown command\r\n", serial_buffer);
            }

            serial_line_ready = false;
            memset(serial_buffer, 0, 1024);
            serial_ix = 0;
        }

        if (button_pressed) {
            printf("<BTN=%lu\r\n", button_count);
            button_pressed = false;
        }

        wait_ms(1);
    }
}
