/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#ifndef __BLE_ULTRA_SERVICE_H__
#define __BLE_ULTRA_SERVICE_H__
 
class UltrasonicService {
public:
    const static uint16_t SERVICE_UUID              = 0xA998;
    const static uint16_t STATE_CHARACTERISTIC_UUID = 0xA999;
 
    UltrasonicService(BLE &_ble) :
        ble(_ble), state(STATE_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&state};
        GattService         service(UltrasonicService::SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(service);
    }
 
    void updateState(uint32_t newState) {
        ble.gattServer().write(state.getValueHandle(), (uint8_t *)&newState, sizeof(uint32_t));
    }
 
private:
    BLE                                     &ble;
    ReadOnlyGattCharacteristic<uint32_t>    state;
};
 
#endif /* #ifndef __BLE_ULTRA_SERVICE_H__ */
 