#include "mbed.h"
#include "SimpleBLE.h"

SimpleBLE ble("HPE_LIGHTSENSOR");
ReadOnlyCharacteristic<uint16_t>* lightChar = ble.createReadOnlyChar<uint16_t>(0x9381, 0x9382, true, 1023);

DigitalOut led(LED1);
AnalogIn  light(A0);

void blink() {
    led = !led;
    
    lightChar->update(light.read_u16());
}

int main(int, char**) {
    Ticker t;
    t.attach(blink, 1.0f);
    
    ble.spin();
    
    // will never return
}
