#include "mbed.h"
#include "HTTPClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "Websocket.h"

const char* ssid = "YOUR_SSID";
const char* pwd = "YOUR_PWD";

ESP8266Interface wifi(D8, D2, D7, ssid, pwd, 115200); // TX,RX,Reset,SSID,Password,Baud
RawSerial pc(USBTX, USBRX); // tx, rx

HTTPClient http;
int main()
{
    // 115200 baud rate to talk back to the PC
    pc.baud(115200);
    
    // need debug messages? check ESP8266Interface/ESP8266/ESP8266.cpp and change the #if 0 to #if 1
    
    pc.printf("\nTrying to connect to %s...!\r\n", ssid);
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    
    pc.printf("Connected to WiFi. IP address = %s\r\n", wifi.getIPAddress());
    
    // For some reason DNS doesn't work. Just use raw IPs for now.
    // GET a page...
    {   
        char buffer[1024];
        HTTPResult ret = http.get("http://54.175.222.246/get", buffer, sizeof(buffer)); //IP address is httpbin.org/get
        if (ret == HTTP_OK) {
            pc.printf("Page fetched successfully - read %d characters\r\n", strlen(buffer));
            pc.printf("Result: %s\n\r", buffer);
        } else {
            pc.printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        }
    }
    
    // POST to a page...
    {
        HTTPMap map;
        char buffer[1024];
        HTTPText inText(buffer, sizeof(buffer));
        map.put("Hello", "World");
        map.put("test", "1234");
        printf("\nTrying to POST data to httpbin.org/post...\r\n");
        HTTPResult ret = http.post("http://54.175.222.246/post", map, &inText); //IP address is httpbin.org/post
        if (ret == HTTP_OK)
        {
            pc.printf("Executed POST successfully - read %d characters\r\n", strlen(buffer));
            pc.printf("Result: %s\n\r", buffer);
        }
        else
        {
            pc.printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        }
    }
}

