#include "mbed.h"
#include "nRF24L01P.h"
 
Serial pc(USBTX, USBRX); // tx, rx
 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut RedLED(LED1);
AnalogIn ldr(A1);
AnalogIn pot(A0);
 
int main()
{
    char count[2];
    char TxDataCnt;
    char temp;
 
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2410);
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
 
    pc.printf( "Wirelesss sensor network \r\n");
        
    TxDataCnt = 2;
    my_nrf24l01p.setTransferSize(TxDataCnt);
 
    my_nrf24l01p.enable();
    
    char ldr_val, pot_val;
    
    while (1) {
        
        //adjusting data to 0-255 with char data type
        ldr_val = 255*(ldr.read());
        pot_val = 255*(pot.read());
        
        count[0] = ldr_val;
        count[1] = pot_val;
        
        // Send the Transmit buffer via the nRF24L01+
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,count, TxDataCnt );
 
        pc.printf( "Sending %d bytes; LDR=%d, POT=%d\r\n",temp,count[0], count[1]);
 
        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        RedLED = !RedLED;
          
        wait(1);
    }
}