/* Program Example 11.2 DSP input and Output con inclusión de filtro LP
*/
#include "mbed.h"
//mbed objects

AnalogIn Ain(p15);

AnalogOut Aout(p18);

Ticker s20khz_tick;

//function prototypes
void s20khz_task(void);

float LPF(float);

//variables and data
float data_in, data_out;

//main program start here
int main()
{
    s20khz_tick.attach_us(&s20khz_task,50); // attach task to 50us tick (20khz)
}

// function 20khz_task. Para realizar un muestreo a intervalos de 50us
void s20khz_task(void)
{
    data_in=Ain;
    data_out=LPF(data_in);  // Ejercicio 11.2
    Aout=data_out;
}

float LPF(float LPF_in)
{
    float a[4]= {1,2.6235518066,-2.3146825811,0.6855359773};
    float b[4]= {0.0006993496,0.0020980489,0.0020980489,0.0006993496};
    static float LPF_out;
    static float x[4], y[4];
    x[3] = x[2];
    x[2] = x[1];
    x[1] = x[0]; // move x values by one sample
    y[3] = y[2];
    y[2] = y[1];
    y[1] = y[0]; // move y values by one sample
    x[0] = LPF_in; // new value for x[0]
    y[0] = (b[0]*x[0]) + (b[1]*x[1]) + (b[2]*x[2]) + (b[3]*x[3])
           + (a[1]*y[1]) + (a[2]*y[2]) + (a[3]*y[3]);
    LPF_out = y[0];
    return LPF_out; // output filtered value
}