#ifndef __AHRS_H_
#define __AHRS_H_

#ifdef __cplusplus
extern "C" {
#endif // #ifdef __cplusplus

#define Kp 2.0f * 5.0f // these are the free parameters in the Mahony filter and fusion scheme, Kp for proportional feedback, Ki for integral
#define Ki 0.0f

void MadgwickQuaternionUpdate(float ax, float ay, float az, float gx, float gy, float gz, float mx, float my, float mz, float deltat, float *q, float beta);
void MahonyQuaternionUpdate(float ax, float ay, float az, float gx, float gy, float gz, float mx, float my, float mz, float deltat, float *q);

#ifdef __cplusplus
}
#endif // #ifdef __cplusplus

#endif // __AHRS_H_