#ifndef __MPU_HAL_H
#define __MPU_HAL_H

#include "i2c_api.h"
#include "wait_api.h"

int mpu_i2c_write(unsigned char slave_addr, unsigned char reg_addr,
                     unsigned char length, unsigned char const *data);
int mpu_i2c_read(unsigned char slave_addr, unsigned char reg_addr,
                     unsigned char length, unsigned char *data);
int get_ms(unsigned long* timestamp);
#define delay_ms wait_ms

#define log_i(...)     do {} while (0)
#define log_e(...)     do {} while (0)
#define min(a,b) ((a<b)?a:b)

#define MPU9250

extern i2c_t* mpu_i2c_dev;
                                          
#endif // __MPU_HAL_H