#include "mpu_hal.h"

#include "i2c_api.h"
#include "wait_api.h"
#include "us_ticker_api.h"

i2c_t* mpu_i2c_dev;

int mpu_i2c_write(unsigned char slave_addr, unsigned char reg_addr,
                     unsigned char length, unsigned char const *data)
{
    if (i2c_byte_write(mpu_i2c_dev, (slave_addr<<1))==0) return -1;
    if (i2c_byte_write(mpu_i2c_dev, reg_addr)==0) return -1;
    for(int i = 0; i < length; i++) {
        if (i2c_byte_write(mpu_i2c_dev, data[i])==0) return -1;
    }
    return 0;
}
int mpu_i2c_read(unsigned char slave_addr, unsigned char reg_addr,
                     unsigned char length, unsigned char *data)
{
    if (i2c_byte_write(mpu_i2c_dev, (slave_addr<<1)|0x01)) return -1;
    if (i2c_byte_write(mpu_i2c_dev, reg_addr)) return -1;
    for(int i = 0; i < (length-1); i++) {
        data[i] = i2c_byte_read(mpu_i2c_dev, 0);
    }
    data[length-1] = i2c_byte_read(mpu_i2c_dev, 1);
    return 0;
}

int get_ms(unsigned long* timestamp) 
{
    *timestamp = (us_ticker_read() / 1000);
    return *timestamp;
}

#define delay_ms wait_ms

#define log_i(...)     do {} while (0)
#define log_e(...)     do {} while (0)
#define min(a,b) ((a<b)?a:b)