#include "mbed.h"
#include "TextLCD.h"
#include "DebouncedIn.h"
#include "QEI.h"
 
AnalogIn Vin(PTC2);
AnalogOut Vout(PTE30);
PwmOut Pwm(PTA5);
float p1 = 0.001;

int PWMmodule(float p1)
{
    Pwm.period(p1);
    Pwm.write(0.1);
    wait(0.1);
    Pwm.write(1);
    wait(0.1);
    Pwm.write(0.5);
    wait(0.1);
    Pwm.write(2);
    wait(0.1);
    Pwm.write(0.01);
    wait(0.1);
    Pwm.write(0.001);
    wait(0.1);
    Pwm.write(0);
    return 0;
}

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); //Puertos LCD rs, e, d4, d5, d6, d7
QEI encoder (PTD7, PTD6, NC, 624);               //Puertos de la tarjeta asignados para el Encoder
 
DigitalOut led1(LED1);      
DigitalOut led2(LED2);      
DigitalOut led3(LED3);      
DebouncedIn boton_encoder(PTC5);    //cambiar la posición- EL BOTON DEL ENCODER

  
   //Códigos LCD
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int C1=0x0E; // Muestra el cursor



int s, kp, ki, kd, sp, dato, spmax, kpmax, kimax, kdmax; // declaracion de variables



 
int main() {

// Ubica e imprime nombre de los parámetros en del PID en la pantalla LCD
    lcd.cls();
    lcd.writeCommand(C1);   //comando para mostrar el cursor en el LCD                   
    lcd.locate(2,0);        
    lcd.printf("Sp=");
    lcd.locate(10,0);
    lcd.printf("Kp=");
    lcd.locate(2,1);
    lcd.printf("Ki=");
    lcd.locate(10,1);
    lcd.printf("Kd=");
    
   
     //Inicio del ciclo
     
     while(1) {
           if (boton_encoder.falling()) {            //Detecta el aumento y disminucion del valor del encoder
               
           PWMmodule(p1);
             encoder.reset(); 
               ++s;
                     if (s>=3){
                    s=0;
                    }
               }
         
                        dato = encoder.getPulses();    //Asigna el valor de los pulsos del encoder a una variable                                                
                        
                        
                        
                        switch(s) {
            
                        case 0:
                        
                        spmax=sp+dato;
                        
                        if(spmax>=999){
                            
                        lcd.locate(4,0);                
                        lcd.printf("=    ",sp);
                        lcd.locate(5,0);
                        lcd.printf("%i",sp);
                        }
                        else {   
                            sp = sp + dato;                
                            encoder.reset();                
                            if (sp<0){
                            sp=0;                       
                            }
                            lcd.locate(4,0);                
                            lcd.printf("=    ",sp);
                            lcd.locate(5,0);
                            lcd.printf("%i",sp);
                        }
                        if (boton_encoder.falling()) {       
                            
                            PWMmodule(p1);
                            
                            s=1;
                            led1=0;
                            wait(.15); 
                            led1=1;
                            encoder.reset();            
                            }
                        break; 
                        
                        case 1:
                        
                        kpmax=kp+dato;
                        
                        if(kpmax>=999){
                            
                        lcd.locate(12,0);                
                        lcd.printf("=    ",kp);
                        lcd.locate(13,0);
                        lcd.printf("%i",kp);
                        }
                        else {   
                       
                        kp = kp + dato;                
                        encoder.reset();                
                        if (kp<0){
                            kp=0;                       
                            }
                        
                        lcd.locate(12,0);                
                        lcd.printf("=    ",kp);
                        lcd.locate(13,0);
                        lcd.printf("%i",kp);
                      }  
                        if (boton_encoder.falling()) {       
                            
                            PWMmodule(p1);
                            
                            s=2;
                            led2=0;
                            wait(.15); 
                            led2=1;
                            encoder.reset();           
                            }
                        break; 
                        
                        case 2:
                       
                         kimax=ki+dato;
                        
                        if(kimax>=999){
                            
                        lcd.locate(4,1);                
                        lcd.printf("=    ",ki);
                        lcd.locate(5,1);
                        lcd.printf("%i",ki);
                        }
                        else {
                        ki = ki + dato;                //Asigna el valor del encoder al parámetro y tiene en cuenta el valor anterior
                        encoder.reset();                //Resetea el valor del encoder
                        if (ki<0){
                            ki=0;                       //No se muestran valores negativos
                            }
                        
                        lcd.locate(4,1);                
                        lcd.printf("=    ",ki);
                        lcd.locate(5,1);
                        lcd.printf("%i",ki);
                    }
                        if (boton_encoder.falling()) {       //Aumenta de posición el cursor a la siguiente parametro
                            
                            PWMmodule(p1);
                            
                            s=3;
                            led3=0;
                            wait(.15); 
                            led3=1;
                            encoder.reset();            //------------- Resetea el valor del encoder
                            }
                        break; 
                        
                        case 3:
                       
                       kdmax=kd+dato;
                        
                        if(kdmax>=999){
                            
                        lcd.locate(12,1);               
                        lcd.printf("=    ",kd);
                        lcd.locate(13,1);
                        lcd.printf("%i",kd);
                        }
                        else {
                        kd = kd + dato;               
                        encoder.reset();               
                        if (kd<0){
                            kd=0;                       
                            }
                        
                        lcd.locate(12,1);               
                        lcd.printf("=    ",kd);
                        lcd.locate(13,1);
                        lcd.printf("%i",kd);
                    }
                        if (boton_encoder.falling()) {       
                            
                            PWMmodule(p1);
                            
                            s=4;
                            led1=0;
                            wait(.15); 
                            led1=1;
                            encoder.reset(); 
                                     
                            }
                        break; 
                    }     
                }             
           
      }
       