#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"


TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); 
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int header =0; //tiempo de cabecera pulso abajo
const int head_H = 4600; //+10% medida con osciloscopio en microsegundos
const int head_L = 4400;//-10%  medida con osciloscopio
const int Tp=300;
int i=0;
const int T_alto=1630;//1630;//ponga su tiempo de la prueba
const int T_bajo=500;//533;//ponga su tiempo de la prueba
const int num_bits = 25;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos

int boton=0;
const int dec1=55;
const int dec2=47;
const int dec4=39;

int dato; // tiempo de cada dato que se lee
  
int main()
{
      
      led1=0;
      led2=0;
      led3=0;       
    while(1)
    {
        
      
        lcd.cls();
        lcd.locate(2,0);
        lcd.printf("Control Irda");
        wait(3);
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Teclas 1 2 o 4");
          
ini1: fflush( stdin );
      header=0;
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo en header
      if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
      else goto ini1;
      
seguir:
       //leo los datos de la trama y se meten a un arreglo
      wait_us(4500);// ES EL TIEMPO DE HEADER QUE NO SE Lee O EL ALTO 
      //led2=0;
      lcd.cls();
      boton=0;
      for(i=0;i<(num_bits-1);++i)
      { // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
        dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
        num[i]=dato;
        wait_us(Tp);   
      }
      wait(0.3); //espero un poquito luego de leer todo el arreglo y ponerlo en pantalla 
 
      for(i=0;i<(num_bits-1);++i)
      {  
        
        if(num[i] > ((T_alto+T_bajo)/2))
            {
                    boton=boton+ (2^(i));
            }
          
      }
                    if(boton==dec1)
                    {    led1=!led1;
                         lcd.cls();
                         lcd.printf("Presiono 1"); 
                         lcd.locate(0,1);
                         lcd.printf("nbit=%d",num_bits);
                         wait(2);
                         lcd.cls();
                         lcd.locate(0,0);
                         lcd.printf("HH:%d",head_H);
                         lcd.locate(8,0);
                         lcd.printf("1log:%d",T_alto);
                         lcd.locate(0,1);
                         lcd.printf("HL:%d",head_L);
                         lcd.locate(8,1);
                         lcd.printf("0log:%d",T_alto);
                         wait(2);
                         boton=0;
                         led1=0;
                  }
                  
                    if(boton==dec2)
                     {
                        led2=!led2;
                        lcd.cls();
                        lcd.printf("Presiono 2"); 
                        lcd.locate(0,1);
                        lcd.printf("nbit=%d",num_bits);
                        wait(2);
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("HH:%d",head_H);
                        lcd.locate(8,0);
                        lcd.printf("1log:%d",T_alto);
                        lcd.locate(0,1);
                        lcd.printf("HL:%d",head_L);
                        lcd.locate(8,1);
                        lcd.printf("0log:%d",T_alto);
                        wait(2);
                        boton=0;
                        led2=0;
                }
                
              if(boton==dec4)
                 {
                        led3=!led3;
                        lcd.cls();
                        lcd.printf("Presiono 4"); 
                        lcd.locate(0,1);
                        lcd.printf("nbit=%d",num_bits);
                        wait(2);
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("HH:%d",head_H);
                        lcd.locate(8,0);
                        lcd.printf("1log:%d",T_alto);
                        lcd.locate(0,1);
                        lcd.printf("HL:%d",head_L);
                        lcd.locate(8,1);
                        lcd.printf("0log:%d",T_alto);
                        wait(2);
                        boton=0;
                        led3=0;    
                 }
                    
                if ((boton!=dec4)&&(boton!=dec2)&&(boton!=dec1)&&(boton!=0))
                { 
                       lcd.cls();
                       lcd.printf("tecla no progamada");
                       lcd.locate(0,1);
                       lcd.printf("nbit=%d",num_bits);
                       wait(2);
                       lcd.cls();
                       lcd.locate(0,0);
                       lcd.printf("HH:%d",head_H);
                       lcd.locate(8,0);
                       lcd.printf("1log:%d",T_alto);
                       lcd.locate(0,1);
                       lcd.printf("HL:%d",head_L);
                       lcd.locate(8,1);
                       lcd.printf("0log:%d",T_alto);
                       wait(2);
                       boton=0;
             }
    }
}