/* See
 * http://lancaster-university.github.io/microbit-docs/advanced/
 * for docs about using the micro:bit library
*/
#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

#include "MicroBit.h"

// a,b line normal vector coordinates, should be normalized, a^2 + b^2 = 1 
// returns if distance of point at coordinates x, y and vector line does not 
// exceed given range
bool inRange(float a, float b, float x, float y, float range = 0.5)
{
    return abs(a*x + b*y) < range;
}
// answer if the LED in row, column should be lit or turned off
bool isLit(float a, float b, int row, int column)
{
    float x = column - 2;
    float y = 2 - row;
    return inRange(a,b,x,y);
}

float deg2rad(int deg)
{
    return (float) deg * M_PI / 180;
}

MicroBit uBit;

int main()
{


    uBit.init();

    while (true) {
        int heading = uBit.compass.heading();
        //uBit.serial.printf("%d\r\n", heading);
        
        float angle = M_PI / 2 - deg2rad(heading); //calculate angle of displayed line
        float a = sin(angle); //calculate line normal vector parameters a, b
        float b = cos(angle); 
        
        for (int row = 0; row < 5; row++) {
            for (int col = 0; col < 5; col++) {
                uBit.display.image.setPixelValue(col,row,isLit(a, b, row, col) ? 255 : 0);
            }
        }
        
        uBit.sleep (100);
    }
}

