#include "debounce_button.h"

DigitalIn button(USER_BUTTON);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
volatile bool button1_enabled = true;
volatile bool button1_buzy = false;
Timeout someTimeout;
Timeout timer;
int counter = 0;
/**
    Some tips and tricks:
    -   To use the built-in LED:
            DigitalOut led1(LED1);
            ...
            led1 = 1;
    -   To delay the call of a function:
            Timeout someTimeout;
            ...
            someTimeout.attach(callback(&someFunction), 0.5) with 0.5 as 500 milliseconds
    -   The variables that are used in interrupt callbacks have to be volatile, 
        because these variables can change at any time. Therefore, the compiler is not 
        going to make optimisations.
*/

/**
    TODO
    ----
    This function:
        -   stores the amount of clicks in a variable which is read by the main loop.
        -   resets the click counter which is used inside this file.
        -   lowers a flag which tells the main loop that the user stopped pressing the button
            such that it can proceed its program.
        -   turns the built-in LED off. Therefore, the user gets informed that the program stopped counting the clicks.
*/

void replay(){
    //replay the multiclick
    for(int i=0;i<counter;i++){
        led2 = 1;
        wait(0.2);
        led2 =0;
        wait(0.2);
    }
}

// This function enables the button again, such that unwanted clicks of the bouncing button get ignored.
void button1_enabled_cb(void)
{
    button1_enabled = true;
    led1 = 0;
    replay();
}

/**
    TODO
    ----
    This function:
        -   turns the built-in LED on, so the user gets informed that the program has started with counting clicks
        -   disables the button such that the debouncer is active
        -   enables the button again after a certain amount of time 
            (use interrupts with "button1_enabled_cb()" as callback.
        -   counts the amount of clicks within a period of 1 second
        -   informs the main loop that the button has been pressed
        -   informs the main loop that the user is clicking the button.
            Therefore, this main loop cannot continue its procedure until the clicks within 1 second have been counted.
*/

void button1_busy_enable(){
    button1_buzy = false;    
}
void button1_onpressed_cb(void)
{
    //button is pressed first time, turn led on
    if(button1_enabled){
        counter = 0;
        // turns the built-in LED on, so the user gets informed that the program has started with counting clicks
        led1 = 1;
        //disables the button such that the debouncer is active
        button1_enabled = false;
        button1_buzy = true;
        timer.attach(callback(&button1_busy_enable),0.1);
        // enables the button again after a certain amount of time (use interrupts with "button1_enabled_cb()" as callback.
        someTimeout.attach(callback(&button1_enabled_cb), 5);
    }else if(!button1_buzy){
        counter++;
        button1_buzy = true;
        timer.attach(callback(&button1_busy_enable),0.1);
    }
    
}