
#include "mbed.h"
#include "Adafruit_ADS1015.h"
//#include "USBSerial.h"

#include <iostream>
#include <map>
#include <string>
#include <stdio.h>

#define SERIALOUT

//#define SERIAL_BAUD_RATE    9600

//library function setup
I2C i2c(p28, p27);
Adafruit_ADS1015 ads(&i2c);
//USBSerial pc; // USB CDC serial port
Ticker graph;


//can stuff
Ticker ticker;
//CAN can1(p9, p10);
CAN can2(p30, p29);
char counter[8] = {1,1,1,1,1,1,1,1};
int test=0x0;
char counter2=0;


bool fromUsr[5] = {false,false,false,false,false}; //cpupwr, cpu rst, sensor, net, usrint



//leds
DigitalOut led0(LED1);
DigitalOut led1(LED2);
DigitalOut led2(LED3);
DigitalOut led3(LED4);

//current readings
AnalogIn iBat(p15); //75a              PROTO
AnalogIn iTwelve(p17); //31a
AnalogIn iFive(p18);//31a              PROTO
AnalogIn iMot(p16);//75a
AnalogIn iCpu(p20);//31a
AnalogIn iPeri(p19);//31a

//voltage scalers
#define batScal 12.2
#define motScal 12.2
#define twelveScal 12.2
#define fiveScal 12.2

//Relays
DigitalOut relSens(p21);              //  PROTO
DigitalOut relUsr(p24);
DigitalOut relNet(p23);
DigitalOut relCpuRst(p22);
DigitalOut relCpuPower(p25);


//30 minute graph arrays
uint16_t powerArr [10]; //{iBat,vBat,iTwelve, vTwelve, iFive, vFive, iMot, vMot, iCpu, iPeri}
uint16_t ibat,vbat,itwelve, vtwelve, ifive, vfive, imot, vmot, icpu, iperi= 0;



//volt
uint16_t vBat, vTwelve,vFive,vMot ;



void sending_values(long int int1,long int int2,long int int3,long int int4, int ID )
{
    //val();
    led1=1;
    counter[0]=int1 >> 8;
    counter[1]=int1 & 0xFF;
    counter[2]=int2 >> 8;
    counter[3]=int2 & 0xFF;
    counter[4]=int3 >> 8;
    counter[5]=int3 & 0xFF;
    counter[6]=int4 >> 8;
    counter[7]=int4 & 0xFF;
    led2=1;
    if(can2.write(CANMessage(ID, counter, 8))) {

        //  printf("Message sent: %x%x\r\n", counter[1],counter[0]);
        //  printf("Should be: %d, %d, %d, %d\r\n", int1,int2,int3,int4);");
    led1=0;
    }
     else
    printf("CAN ERROR");
   
}






void Can_main(long int val1,long int val2,long int val3,long int val4, int the_ID)
{

    std::map <int,string> CanIDMap;

    CanIDMap[0]=" ";
    CanIDMap[1]="Message id 1: Batt Cur, Batt Volt, Twelve Cur, Twelve Volt";
    CanIDMap[2]="Message id 2: Five Cur, Five Volt, Mot Cur, Mot Volt,";
    CanIDMap[3]="Message id 3: Cpu Cur,  Perifferal Cur, null,  null....";
    CanIDMap[4]="Message id 4: Network switch, usrint switch, sensor on switch, null";
    CanIDMap[5]="Message id 5: cpupwr switch, cpu rst switch,null,null.";
    CanIDMap[6]=" ";
    CanIDMap[7]=" ";
    CanIDMap[8]=" ";
    CanIDMap[9]=" ";
    CanIDMap[10]=" ";
    CanIDMap[11]=" ";
    CanIDMap[12]="Zac is the Worst";
    CanIDMap[13]="Auto";
    CanIDMap[14]="Manual";





    //ticker.attach(&sending_values,1);
    CANMessage msg;
    int fixer1=0;
    int fixer2=0;
    int fixer3=0;
    int fixer4=0;


    if(can2.read(msg)) {
        bool tester= CanIDMap.find(msg.id) != CanIDMap.end();
        if (tester) {
            //printf("Message received: %x %x \r\n", msg.data[0], msg.data[1]);

            //printf("ID of message: %s \r\n", CanIDMap[msg.id]);

            std::string str=CanIDMap[msg.id];
            unsigned pos = str.find("_");         // position of "_" in str
            std::string str3 = str.substr (pos+1);     // get from past"_" to the end
            // printf("Dealing with: %s \r\n",str3);
            fixer1=((msg.data[0]<<8) | (msg.data[1]));
            fixer2=((msg.data[2]<<8) | (msg.data[3]));
            fixer3=((msg.data[4]<<8) | (msg.data[5]));
            fixer4=((msg.data[6]<<8) | (msg.data[7]));
            if(msg.id==4) { // "Message id 4: Network switch, usrint switch, sensor on switch, null";
fromUsr[3]=fixer1;    //fromUsr=cpupwr, cpu rst, sensor, net, usrint
fromUsr[4]= fixer2;
fromUsr[2]=fixer3;
            }


            else if(msg.id==5) { // "Message id 5: cpupwr switch, cpu rst switch,";
fromUsr[0]=fixer1;    //fromUsr=cpupwr, cpu rst, sensor, net, usrint
fromUsr[1]= fixer2;


            }

            else{
                led3=!led3;
                }
            led2 = !led2;

            // printf("Resulting Answer back is: %d, %d, %d, %d\r\n\r\n\r\n",fixer1,fixer2,fixer3,fixer4 );

        }

        else {

            // printf("Can Message, not related to this controller\r\n\r\n");

        }

        //wait(0.2);
    }





}




void sendArray (void)
{
#ifdef SERIALOUT
    printf("___________________________\r\n");
    printf("Sending messages....\r\n");
    printf("Message id 1: Batt Cur = %d, Batt Volt = %d, Twelve Cur = %d, Twelve Volt = %d....",powerArr[0],powerArr[1],powerArr[2],powerArr[3]);
    sending_values(powerArr[0],powerArr[1],powerArr[2],powerArr[3],1);
    printf("....sent\r\n");
    printf("Message id 2: Five Cur = %d, Five Volt = %d, Mot Cur = %d, Mot Volt = %d....",powerArr[4],powerArr[5],powerArr[6],powerArr[7]);
    sending_values(powerArr[4],powerArr[5],powerArr[6],powerArr[7],2);
    printf("....sent\r\n");
    printf("Message id 3: Cpu Cur = %d,  Perifferal Cur = %d, null,  null....",powerArr[8],powerArr[9]);
    sending_values(powerArr[8],powerArr[9],0,0,3);
    printf("....sent\r\n");
    printf("CANBUS TRANMISSION COMPLETE\r\n");
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~\r\n");
    //relNet=!relNet;
  //  relSens= !relSens;


    //relCpuPower=!relCpuPower;
    //relCpuRst =!relCpuRst;
    // relUsr=!relUsr;
    float neW =(powerArr[1]*.003);
    printf("actual vbat= %2.4f volt\r\n", neW);
#endif
#ifndef SERIALOUT
    sending_values(powerArr[0],powerArr[1],powerArr[2],powerArr[3],1);
    sending_values(powerArr[4],powerArr[5],powerArr[6],powerArr[7],2);
    sending_values(powerArr[8],powerArr[9],0,0,3);
   // relNet=!relNet;
    //relSens= !relSens;

    //relCpuPower=!relCpuPower;
    //relCpuRst =!relCpuRst;
   // relUsr=!relUsr;
#endif

}



void setup(void)
{
    graph.attach(&sendArray, (1)); //update array every 10 seconds

 can2.frequency(500000);
    //initialize relays
    relSens= 0;

    relNet =0;
    relCpuPower=0;
    relCpuRst =0;
    relUsr=0;
wait(3);
sending_values(1,1,1,1,4);
wait(.01);
sending_values(0,0,0,0,4);



}



int main()
{
    setup();


    while (1) {
        Can_main(0,0,0,0,0);



        powerArr[0]=ibat = (iBat.read_u16());
        powerArr[1]=vBat = ads.readADC_SingleEnded(0); // read channel 0    PROTO

        powerArr[2]=itwelve = (iTwelve.read_u16());
        powerArr[3]=vtwelve = ads.readADC_SingleEnded(1); // read channel 1

        powerArr[4]=ifive = (iFive.read_u16());
        powerArr[5]=vfive = ads.readADC_SingleEnded(2); // read channel 0

        powerArr[6]=imot = (iMot.read_u16());
        powerArr[7]=vmot = ads.readADC_SingleEnded(3); // read channel 0

        powerArr[8]=icpu = (iCpu.read_u16());
        powerArr[9]=iperi = (iPeri.read_u16());

//powerArr[] = {ibat,vbat,itwelve, vtwelve, ifive, vfive, imot, vmot, icpu, iperi};

        relCpuPower=fromUsr[0];
        relCpuRst =fromUsr[1];
        relSens= fromUsr[2];
        relNet =fromUsr[3];
        relUsr=fromUsr[4];


//cpupwr, cpu rst, sensor, net, usrint

        led0=!led0;

    }
}




















