#include "mbed.h"
#include "DHT.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#define ECHO_SERVER_PORT   7
 
int arrivedcount = 0;
 
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void baud(int baudrate) {
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main (void)
{
    DHT sensor(D4, DHT11);
    baud(115200);
    printf("Wait a second...\r\n");
    char* topic = "openhab/parents/command";
    MQTTEthernet ipstack = MQTTEthernet();
    
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "192.168.1.99";
    int port = 1883;
    
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\n", rc);
        
    printf("Topic: %s\r\n",topic);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "parents";

    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\n", rc);
 
    if ((rc = client.subscribe(topic, MQTT::QOS1, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\n", rc); 
        
    MQTT::Message message;
    char buf[100];
    int error = 0;
    float hum = 0.0f, temp = 0.0f;
    while (true) 
    {
        error = sensor.readData();
        if (0 == error) {
            hum = sensor.ReadHumidity();
            temp = sensor.ReadTemperature(CELCIUS);
        }
        sprintf(buf, "%3.1f", hum);
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("openhab/parents/humidity", message);
        sprintf(buf, "%3.1f", temp);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("openhab/parents/temperature", message);
        
        client.yield(60000);
    }
}

