#include "mbed.h"
#include "HCSR04.h"
#include "AutomationElements.h"

DigitalIn  mypin(D4);
PwmOut Buzzer(D5);
DigitalOut myled(D7);
Serial pc(USBTX, USBRX);
HCSR04 sensor(D8, D9);
float sampleTime = 0.5;
PT1 filter(1, 2, sampleTime);
Ticker ticker;
float distance;
float filteredDistance; 

void calc() {
    sensor.startMeasurement();
}

int main() {
    sensor.setRanges(2, 400);
    pc.printf("Minimum sensor range = %g cm\n\rMaximum sensor range = %g cm\n\r", sensor.getMinRange(), sensor.getMaxRange());
    pc.printf("Sensor:       Filtered:\n\r");
    ticker.attach(&calc, sampleTime);
    while(true) {
        while(!sensor.isNewDataReady()) {
        // wait for new data
        }
        float distance = sensor.getDistance_cm();
        filter.in(distance);
        filteredDistance = filter.out();
        pc.printf("%7.1f cm  %7.1f cm\n\r", distance, filteredDistance);
        
        if(distance<10 && mypin == 1){
            pc.printf("intruder alert");
            myled = 1;
            Buzzer = 1;
        }
        else{
            myled = 0;
            Buzzer = 0;
        }
    }
}