/*
 * SiSK-FRDM-K64F-USB-Keyboard
 *
 * Application written for "Standardy i Systemy Komunikacyjne" (SiSK) laboratory
 * classes conducted at AGH UST, Faculty of Computer Science, Electronics and
 * Telecommunications.
 *
 * This software presents interrupts handling and USB Keyboard emulation using
 * FRDM-K64F board.
 * 
 * User is encouradged to change "print_txt_sw2" and "print_txt_sw3" functions,
 * in order to define one's own strings that are going to be printed when SW2
 * or SW3 buttons are pressed on FRDM-K64F board.
 *
 * Important! After programming the FRDM-K64F board, remember to connect it to
 * the PC using "K64 USB" port and not "SDA USB" port. 
 *
 * Author: Jakub Nawała <jakub.tadeusz.nawala@gmail.com>
 */

#include "mbed.h"
#include "USBMouseKeyboard.h"

/* Create interrupts for handling buttons press events */
InterruptIn button_sw2(SW2);
InterruptIn button_sw3(SW3);

/* Create green LED object */
DigitalOut green_led(LED_GREEN);

/* Create USB keyboard object */
USBKeyboard frdm_keyboard;

/* Define global flags for control of prints connected with button presses */
bool sw2_pressed = false;
bool sw3_pressed = false;

/* Interrupt handlers for buttons press events */
void sw2_int_handler() {
    sw2_pressed = true;
    green_led = !green_led;
}

void sw3_int_handler() {
    sw3_pressed = true;
    green_led = !green_led;
}

/* Functions for printing a text bonded with each button */
void print_txt_sw2() {
    frdm_keyboard.printf("foo\n\r");
}

void print_txt_sw3() {
    frdm_keyboard.printf("bar\n\r");
}

/* Main body of the application */
int main(void) {
    /* Initialize LED */
    green_led = 0;
    
    /* Setup interrupts for falling edge detected on the buttons pins */
    button_sw2.fall(&sw2_int_handler);
    button_sw3.fall(&sw3_int_handler);
    
    /* Check what button was pressed and print appropriate text */
    while (true) {
        if(sw2_pressed) {
            print_txt_sw2();
            sw2_pressed = false;
        }
        if(sw3_pressed) {
            print_txt_sw3();
            sw3_pressed = false;
        }
        
        /* Wait for interrupts */
        wait(0.5f);
    }

    /* This place shall never be reached! */
}
