// A solution to OCE360 Homework #4.
// Objective: Use object oriented programming to create a system that displays
// multiple balls bouncing around the LCD screen.
// Stephen Licht, 11/7/2017

#include "mbed.h"
#include "MMA8452Q.h"           //acceleromater library
#include "uLCD_4DGL.h"          //LCD library
#include "bouncing_ball.h"      //new ball phyics library
#include "SDFileSystem.h"

#define UPDATE_TIME_S 0.02
#define START_X_1 10
#define START_Y_1 10
#define START_X_2 20
#define START_Y_2 20
#define RADIUS_1 6
#define RADIUS_2 3

#define DEBUG_MODE 0

// Variables for SD file system code
FILE *file;
float voltage_in;
float degrees_c;
int n = 0;
int c;

// Define Tickers/timers
Ticker flipper1; 
Ticker flipper2;
Timer timestamp;
Timer debounce;                 // debounce timer for Record external interrupt
Timer debounce2;                // debounce timer for LCDshow ecternal interrupt

//internal leds
DigitalOut myled2(LED2);
DigitalOut myled4(LED4);

//Function prototype for color selection and Ticker updates
int get_LCD_color(int color_integer);
void LCD_update(void);          // LCD screen update function prototype
void BALL_update(void);         // Ball update function prototype
void recording(void);           // Recording function prototype
void display(void);             // Display LCD screen function Prototype
void flip2() {                  // flip 2 function
 myled2 = !myled2;
}

// Temperature Analog input (pin 15)
AnalogIn ain(p15);

// External Interrupt inputs
InterruptIn record(p18);
InterruptIn LCDshow(p17);

// SD card (SPI pins)
SDFileSystem sd(p5, p6, p7, p8, "sd");

//Define Serial Terminal
Serial pc(USBTX, USBRX);

// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p9,p10,p11);     //initialize a driver object for an LCD connected on pins 9-11

// Accelerometer - SDA, SCL, and I2C address
MMA8452Q accel(p28, p27, 0x1D);  //initialize a driver object for an accelerometer connected on pins 27-28.

physics_ball ball1;  //initialize two balls for bouncing
physics_ball ball2;  //the default states from the library will be used initially

int main()
{
    // led for ball update
    myled2 = 0;
    myled4 = 0;
    flipper2.attach(&flip2, .02);
    
    // Initialize uLCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();  
    
    // Initialize accelerometer
    accel.init();

    //Initialize balls:
    ball1.set_state(START_X_1,START_Y_1,0,0); //speeds are set to zero
    ball1.set_state(START_X_2,START_Y_2,0,0);

    //Set ball radius and color:
    ball1.set_param(RADIUS_1,0); //color is unimportant
    ball2.set_param(RADIUS_2,1); //just making sure the colors are different
    
    // Start Timers and Tickers
        debounce.start();
        debounce2.start();
    
    flipper2.attach(&BALL_update, 0.02); // update ball position @ 50hz
    flipper1.attach(&LCD_update, 0.0909); // update LCD screen @ 11hz
    
    //hardwareinterrupt
    record.rise(&recording);
    LCDshow.rise(&display);
            
    /* Make the balls "fall" in direction of accelerometer by forcing the ball objects
     to update themselves at regular intervals, and te drawing the locations reported
     by the ball objects on the LCD screen: */
    while (1) {  //execute 'forever'
    }
    }
        // Functions:
        void display()
}
        void LCD_update()  {   // LCD screen update function
    
    
        // Draw circles in the x and y positions stored by the ball objects:
        uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, get_LCD_color(ball1.color));
        uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, get_LCD_color(ball2.color));

        // Wait before erasing old circles:
        wait(UPDATE_TIME_S);         // In seconds

        // Erase old circles by writing over there locations using the screen color:
        uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, BLACK);
        uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, BLACK);

    }
        void BALL_update()      // BALL position update function
    {

        // Force the objects 'ball1' and 'ball2' to update their stored positions
        // and velocities:
        ball1.update(UPDATE_TIME_S,accel);
        ball2.update(UPDATE_TIME_S,accel);

        myled2=!myled2;
        
        // Potential way of counting updates
                n = n + 1;   
                
        void recording() { 
        
    if (debounce.read_ms()>200)    // only allow function if debounce timer   
        // Resets and starts time stamp timer
            timestamp.reset();
            timestamp.start();
        // Turn onboard LED on
            myled4 = 1;
            
    // Open file for writing
    file = fopen("/sd/temp_data.txt", "w");
    if ( file == NULL ) {
        error("ERROR: Could not open file for writing!\n\r");
        return -1;
    }

    // Tell the user we need to wait while we collect some data
    pc.printf("\nCollecting data (Do not remove SD Card!) ...\n\r");        
               
         // Collect temperatures with timestamps every second
    for(i = 0; i < 10; i++) {
        voltage_in = ain * 3.3;
        degrees_c = (voltage_in - 0.5) * 100.0;
        fprintf(file, "%2.2fs: %3.1f deg C\n\r", timer.read(), degrees_c);
        wait(1);
    }

    // Close file and re-open it for reading
    fclose(file);
    file = fopen("/sd/temp_data.txt", "r");
    if ( file == NULL ) {
        error("ERROR: Could not open file for reading!\n\r");
        return -1;
    }

    // Print results to console
    pc.printf("Temperature data:\n\r");
    while(1) {
       c = fgetc(file);
       if ( c == EOF ) {
           break;
       }
       pc.putc(c);
    }

    // Close the file and finish
    fclose(file);
    pc.printf("Done! Safe to remove SD card\n\r");

    return 0;
}


//Interpret LCD colors.
int get_LCD_color(int color_integer)
{
    switch (color_integer) {
        case 0:
            return(RED);
        case 1:
            return(BLUE);
        case 2:
            return(GREEN);
        default:
            return(WHITE);
    }
}