//Assignment 3
//Jake Bonney
//OCE 360

//Display temp sensor output to serial terminal connection in Fahrenheit
//Turn on leds for specific temperature outputs

#include "mbed.h"

Serial pc(USBTX, USBRX); //serial connection
AnalogIn TMP36(p15); // Temp sensor
DigitalOut myled1(LED1); //internal led
DigitalOut myled2(LED2); //internal led
DigitalOut myled3(LED3); //internal led
DigitalOut myled4(LED4); //internal led
PwmOut red_led(p21);
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // ABCDEFGDP 7 segment display

int main() {
    float tempC, tempF;
 
    while(1) {
        //conversion to degrees C celcius from TMP36 output
        tempC = (((TMP36*3.3)*30.0)-15.0);
        //convert to degrees F fahrenheit
        tempF = (9.0*tempC)/5.0 + 32.0;
        //print current temp to serial output
        printf("%5.2F C %5.2F F \n\r", tempC, tempF);
        wait(.5);
        
        if (tempF <=30){
            //tempF is below 0...no internal leds on
            myled1=0;
            myled2=0;
            myled3=0;
            myled4=0;
            Seg1=0x3F; // 00111111 binary LEDs to '0'
            red_led.write(0.0f);
            }
            else if (tempF > 30 and tempF <= 50){
                //tempF is between 0 and 30...led1 is on
                myled1=1;
                myled2=0;
                myled3=0;
                myled4=0;
                Seg1=0x06; // 00000110 binary LEDs to '1'
                red_led.write(0.25f);
            }
            else if (tempF > 50 and tempF <= 70){
                //tempF is between 30 and 60...leds 1/2 are on
                myled1=1;
                myled2=1;
                myled3=0;
                myled4=0;
                Seg1=0x5B; // 01011011 binary LEDs to '2'
                red_led.write(0.5f);
            }
            else if (tempF > 70 and tempF <= 90){
                //tempF is between 60 and 100...leds 1/2/3 are on
                myled1=1;
                myled2=1;
                myled3=1;
                myled4=0;
                Seg1=0x4F; // 01001111 binary LEDs to '3'
                red_led.write(0.75f);
                
            }
            else if (tempF > 90){
                //tempF is greater than 100...all leds are on
                myled1=1;
                myled2=1;
                myled3=1;
                myled4=1;
                Seg1=0x66; // 01100110 binary LEDs to '4'
                red_led.write(1.0f);
            }
 }
}