// Copyright (c) 2013, jake (at) allaboutjake (dot) com
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * The name of the author and/or copyright holder nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER, AUTHOR, OR ANY CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// DESCRIPTION OF FILE:
//
// This file contains the globals and other definitions for used throughout the
// firmware.
//

#include "mbed.h"
#include "Mini_DK.h"
#include "Target.h"
#include "makerbot.h"
#ifndef __MAIN_H__
#define __MAIN_H__

#define MAX_PROMPT_BUFFER_SIZE 80
#define FIRMWARE_VERSION "0.2"

#ifdef TARGET_MINIDK

    //Define the pins and objects related to the Mini_DK2 development board
    extern DigitalOut led1;
    extern DigitalOut led2;
    extern DigitalOut usbpwr;

    extern InterruptIn key1;
    extern InterruptIn key2;

#ifdef MINIDK_HAS_LCD
    // TFT -> mosi, miso, sclk, cs
    extern SPI_TFT TFT;

    // ADS7843 -> mosi, miso, sclk, cs, irq, SPI_TFT
    //TouchScreenADS7843 TP(TP_SDI ,TP_SDO ,TP_SCK ,TP_CS ,TP_IRQ, &TFT);
    
    //The Mini_DK2 supports an LCD TFT interface, set a DISPLAY macro for printing to TFT
    #define DISPLAY(...) TFT.printf(##__VA_ARGS__)
#else
    // If we're running a MINI_DK with no LCD, then redirect to the serial interface
    #define DISPLAY(...) pc.printf(##__VA_ARGS__)
#endif

#endif

#ifdef TARGET_MBED
    extern DigitalOut led1;
    extern DigitalOut led2;

    //The stock mbed does not have a TFT display, so redirect DISLAY commands to the serial interface
    #define DISPLAY(...) pc.printf(##__VA_ARGS__)
#endif

//Declare the serial interface
extern Serial pc;
extern Makerbot* bot;

#endif

