// Copyright (c) 2013, jake (at) allaboutjake (dot) com
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * The name of the author and/or copyright holder nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER, AUTHOR, OR ANY CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// DESCRIPTION OF FILE:
//
// This file contains routines for storing and retreiving settings values in flash.
// Currently, there is only one thing stored in flash: the username/password for
// authentication.  This makes the routine very simple.  However, if more settings
// become necessary, a more advanced method for managing the block of memory in
// flash will need to be created.
//

#include "settings.h"
#include "mbed.h"
#include "main.h"

IAP iap;

// This function clears the memory block and stores the new authenticaiton token in flash
void setAuthenticationToken(char* token, int length) {
    if (length+1 < IAP_MEM_SIZE) {
        char terminatedToken[IAP_MEM_SIZE];
        memcpy(terminatedToken, token, length);
        terminatedToken[length]=0;//terminator
        
        // Erase the flash area
        iap.prepare( TARGET_SECTOR, TARGET_SECTOR );       
        iap.erase( TARGET_SECTOR, TARGET_SECTOR );       
        
        // Write the new value
        iap.prepare( TARGET_SECTOR, TARGET_SECTOR );               
        iap.write( terminatedToken, sector_start_adress[ TARGET_SECTOR ], IAP_MEM_SIZE );        
    }
}

// This function checks to see if the memory is blank.  If it is, a password hasn't been set
// If no password, return NULL, otherwise return the autenticaiton token. (username:password)
char* getAuthenticationToken() {    
    int r   = iap.blank_check( TARGET_SECTOR, TARGET_SECTOR );
        
    if (r == 0) {
        //If the memory is blank, then the token isn't in there.
        return NULL;
    }
                   
    char* token   = (char*)sector_start_adress[ TARGET_SECTOR ];
    return token;    
}
