// Example program for reading and writing to the TMPx75 temperature sensor
// Jacobus L de Jager 2018

#include "mbed.h"
#include "TMPx75.h"

Serial pc(SERIAL_TX, SERIAL_RX, 115200);
I2C i2c(I2C_SDA,I2C_SCL);
TMPx75 tmp75(&i2c, 0x48);

int main()
{
    printf("\nTMPx75 example\n");
    
    while(1) 
    {
        pc.printf("\nreading temperature\n");
        float temp = tmp75.read_temperature();
        printf("temp = %f\n", temp);
        
        pc.printf("writing config\n");
        tmp75.write_configuration(RESOLUTION_12_BITS);  
        
        pc.printf("reading config\n");
        int config = tmp75.read_configuration();
        printf("config register = 0x%x\n", config);

        pc.printf("reading T LOW\n");
        float T_LOW = tmp75.read_T_LOW();
        printf("T LOW = %f\n", temp);
        
        pc.printf("reading T HIGH\n");
        float T_HIGH = tmp75.read_T_HIGH();
        printf("T HIGH = %f\n", temp);
        
        pc.printf("writing T LOW\n");
        tmp75.write_T_LOW(25);
        
        pc.printf("writing T HIGH\n");
        tmp75.write_T_HIGH(50);

        printf("done!\n");
        
        wait(0.5);         
    }
}
