#include "TMPx75.h"

// Constructor
TMPx75::TMPx75(I2C *i2c, uint8_t i2c_addr = 0x48) : pc(USBTX, USBRX)
{
  _i2c = i2c;
  _i2c_addr = i2c_addr;
  pc.baud(115200);
}

// Destructor
TMPx75::~TMPx75() 
{ 

}

float    TMPx75::read_temperature()
{
        char data_write[1];
        data_write[0] = (TEMPERATURE_REGISTER);
        char data_read[2];
        
        _i2c->write((_i2c_addr<<1), data_write, 1, 1); // no stop
        _i2c->read((_i2c_addr<<1), data_read, 2, 0);
              
        int tempval = (int)((int)data_read[0] << 8) | data_read[1];

        tempval >>= 4;
        if (tempval > 2048) 
        {
            tempval = 4096 - tempval;
        }

        float temp = (float)tempval/16;
   
        return temp;
}

int    TMPx75::read_configuration()
{
        char data_write[1];
        data_write[0] = (CONFIGURATION_REGISTER);
        char data_read[1];
        _i2c->write((_i2c_addr<<1), data_write, 1, 1); // no stop
        _i2c->read((_i2c_addr<<1), data_read, 1, 0);
        
        return (int)data_read[0];
}

void    TMPx75::write_configuration(uint8_t config_byte = DEFAULT_CONFIG)
{
        char data_write[2];
        data_write[0] = (CONFIGURATION_REGISTER);
        data_write[1] = (config_byte | DEFAULT_CONFIG);
        _i2c->write((_i2c_addr<<1), data_write, 2, 0); 
}

float    TMPx75::read_T_LOW()
{
        char data_write[1];
        data_write[0] = (T_LOW_REGISTER);
        char data_read[2];

        _i2c->write((_i2c_addr<<1), data_write, 1, 1); // no stop
        _i2c->read((_i2c_addr<<1), data_read, 2, 0);
        
        int temp = (int)((int)data_read[0] << 8) | data_read[1];
        temp >>= 4;
        float t_low = (float)temp/16;
        
        return t_low;
}

void   TMPx75::write_T_LOW(float temp)
{    
        temp = temp * 16;
        unsigned int u_temp = temp;
        u_temp = u_temp << 4;
        
        char data_write[3];
        data_write[0] = (T_LOW_REGISTER);
        data_write[1] = (u_temp>>8);
        data_write[2] = (u_temp);
            
        _i2c->write((_i2c_addr<<1), data_write, 2, 0);       
}

float   TMPx75::read_T_HIGH()
{
        char data_write[1];
        data_write[0] = (T_HIGH_REGISTER);
        char data_read[2];

        _i2c->write((_i2c_addr<<1), data_write, 1, 1); // no stop
        _i2c->read((_i2c_addr<<1), data_read, 2, 0);
        
        int temp = (int)((int)data_read[0] << 8) | data_read[1];
        temp >>= 4;
        float t_high = (float)temp/16;
        
        return t_high;
}

void    TMPx75::write_T_HIGH(float temp)
{
        temp = temp * 16;
        unsigned int u_temp = temp;
        u_temp = u_temp << 4;
        
        char data_write[3];
        data_write[0] = (T_HIGH_REGISTER);
        data_write[1] = (u_temp>>8);
        data_write[2] = (u_temp);
        
        _i2c->write((_i2c_addr<<1), data_write, 2, 0);     
}