#include "mbed.h"
#include "Encoder.h"

/***********************************************************
Constructor
***********************************************************/
Encoder::Encoder(PinName mosi, PinName miso, PinName sck, PinName ncs): _cs(ncs), _spi(mosi,miso,sck), enc2deg(360./(pow(2.,14.)-1)), zero_ang(1),sign(1)
{
    // When CSPin is high the device is unselected
    _cs = 1;

    //format SPI for 16 bit data, low steady state clock, second edge capture with 10MHz clock
    _spi.format(16,1);
    _spi.frequency(96000000);
}

/***********************************************************
Parity Check Function
***********************************************************/
//Parity check.  Will be 0 if parity fails.  This is used for a safety check.

bool Encoder::parity_calc(int x)
{
    x ^= x >> 8;
    x ^= x >> 4;
    x ^= x >> 2;
    x ^= x >> 1;
    x &= 1;
    return x;
}

/***********************************************************
Initialize Read_Encoder
***********************************************************/
//Taken from Init.cpp, used to be zero_ang_L, changed to zero_ang to accompany change to local variable
//approximate point where the pilot should be standing straight

void Encoder::init(float blah)
{
    zero_ang=blah;
}

/***********************************************************
Read_Encoder Program
***********************************************************/
//Reads the encoder, does parity check, and stores the error flag.
//@returns An unsigned integer which is the number of ticks away from the zero position.

int Encoder::read()
{
    // Select the device by seting chip select low
    _cs = 0;

    //send a dummy byte to the MOSI to get a reading through the MISO
    raw=_spi.write(0xFFFF);

    // Set the select back to low to allow the encoder to chill
    _cs=1;

    // XNOR parity check
    parity=~(parity_calc(raw) ^ (raw>>15));

    // Mask and bit shift to look at encoder flag value
    enc_flag=(raw & 0x4000)>>14;

    raw&=0x3FFF;

    return raw;
}

short int Encoder::readRaw(){
    return raw;
    }
/***********************************************************
Translate Function - Translates Ticks to Position
***********************************************************/
// Translates the left encoder value from encoder ticks into degrees from the pilot's zero.
// @param ticks The number of encoder ticks from the encoder zero to the current position.
// @returns A float which is the degrees away from the pilot's zero position.


float Encoder::angle()
{
    // converts the result (encoder tick position) to degrees
    float pos = -sign*read()*enc2deg+zero_ang;
    return pos;
}

/***********************************************************
Get parity from parityFlag
***********************************************************/
//Error Flag.  The encoder has a built in hardware error flag.  This is used for a safety check.

bool Encoder::parityFlag()
{
    return parity;
}

/***********************************************************
Get enc_flag from encFlag
***********************************************************/
bool Encoder::encFlag()
{
    return enc_flag;
}

void Encoder::flip()
{
    sign=-sign;
    }