#include "body.h"

Body::Body()
{
}
Body::~Body()
{
}

void Body::init()
{
    sx0 = 12;
    sx1 = 13;
    sx2 = 14;
    sx3 = 15;
    sx4 = 16;
    sx5 = 17;
    sx6 = 18;
    sx8 = 19;
    sx9 = 20;
    
    sy0 = 6;
    sy1 = 6;
    sy2 = 6;
    sy3 = 6;
    sy4 = 6;
    sy5 = 6;
    sy6 = 6;
    sy7 = 6;
    sy8 = 6;
    sy9 = 6;
    
    score = 0;
    endgame = false;
    input_check = Button_right;
}

void Body::game_end(N5110 &lcd){
    if (21 < sx0 < 63){/**If snake hits vertical line*/
        if (sy0 == 24){
            endgame = true;
        }
    }
    if (12 < sy0 < 36){/**if snake hits horizontal line*/
        if (sx0 == 42){
            endgame = true;
        }
    }
    if ((sx0 == sx1 && sy0 == sy1) || (sx0 == sx2 && sy0 == sy2) || (sx0 == sx3 && sy0 == sy3) || (sx0 == sx4 && sy0 == sy4) || (sx0 == sx5 && sy0 == sy5) || (sx0 == sx6 && sy0 == sy6) || (sx0 == sx7 && sy0 == sy7) || (sx0 == sx8 && sy0 == sy8) || (sx0 == sx9 && sy0 == sy9))
    {
        endgame = true;
    }
}

void Body::visual(N5110 &lcd, Gamepad &pad, Food &food)
{
    lcd.clear();
    
    char buffer[12];
    sprintf(buffer,"Score = %2d", score);
    lcd.printString(buffer,0,1);
    
    lcd.setPixel(food.fo_x, food.fo_y, true);
    
    lcd.drawLine(21,24,63,24,1);
    lcd.drawLine(42,12,42,36,1);
    
    lcd.setPixel(sx0, sy0, true);
    lcd.setPixel(sx1, sy1, true);
    lcd.setPixel(sx2, sy2, true);
    lcd.setPixel(sx3, sy3, true);
    lcd.setPixel(sx4, sy4, true);
    lcd.setPixel(sx5, sy5, true);
    lcd.setPixel(sx6, sy6, true);
    lcd.setPixel(sx7, sy7, true);
    lcd.setPixel(sx8, sy8, true);
    lcd.setPixel(sx9, sy9, true);
    
    if (endgame == true){
        lcd.clear();
        pad.tone(1500.0,1.0);
        
        lcd.drawRect(10,5,64,38,FILL_TRANSPARENT);
        lcd.printString("YOU DIED", 21, 2);
        char buffer2[12];
        sprintf(buffer2,"you got %2d", score);
    }
    
    lcd.refresh();
}

void Body::user_input(Gamepad &pad)
{
        Input input = input_check;
        
        if(input != Button_left){
            if(pad.A_pressed()){
                input_check = Button_right;
            }
        }
        if(input != Button_right){
            if(pad.Y_pressed()){
                input_check = Button_left;
            }
        }
        if(input != Button_top){
            if(pad.B_pressed()){
                input_check = Button_bottom;
            }
        }
        if(input != Button_bottom){
            if(pad.X_pressed()){
                input_check = Button_top;
            }
        }
        else{
            input_check = input_check;
        }
}

bool Body::endgame_check()
{
    return endgame;
}

void Body::food_eaten(N5110 &lcd, Gamepad &pad, Food &food)
{
    if ((sx0 == food.fo_x) && (sy0 == food.fo_y))
    {
        score = score + 1;
        food.chng_food = true;
        pad.led(1,1);
        wait(0.2);
        pad.led(2,1);
        wait(0.2);
        pad.led(3,1);
        wait(0.2);
        pad.led(4,1);
        wait(0.2);
        pad.led(5,1);
        wait(0.2);
        pad.led(6,1);
        wait(0.2);
        pad.led(1,0);
        wait(0.2);
        pad.led(2,0);
        wait(0.2);
        pad.led(3,0);
        wait(0.2);
        pad.led(4,0);
        wait(0.2);
        pad.led(5,0);
        wait(0.2);
        pad.led(6,0);
    }
}

int Body::score_display()
{
    return score;
}

void Body::movement(){
    if (input_check == Button_top){
        sx9 = sx8;
        sx8 = sx7;
        sx7 = sx6;
        sx6 = sx5;
        sx5 = sx4;
        sx4 = sx3;
        sx3 = sx2;
        sx2 = sx1;
        sx1 = sx0;
        sy9 = sy8;
        sy8 = sy7;
        sy7 = sy6;
        sy6 = sy5;
        sy5 = sy4;
        sy4 = sy3;
        sy2 = sy2;
        sy2 = sy1;
        sy1 = sy0;    
        
        sx0 = sx0;
        sy0 = sy0 - 1;
        
    }
    if (input_check == Button_right){
        sx9 = sx8;
        sx8 = sx7;
        sx7 = sx6;
        sx6 = sx5;
        sx5 = sx4;
        sx4 = sx3;
        sx3 = sx2;
        sx2 = sx1;
        sx1 = sx0;
        sy9 = sy8;
        sy8 = sy7;
        sy7 = sy6;
        sy6 = sy5;
        sy5 = sy4;
        sy4 = sy3;
        sy2 = sy2;
        sy2 = sy1;
        sy1 = sy0;    
        
        sx0 = sx0 + 1;
        sy0 = sy0;
    }
    if (input_check == Button_bottom){
        sx9 = sx8;
        sx8 = sx7;
        sx7 = sx6;
        sx6 = sx5;
        sx5 = sx4;
        sx4 = sx3;
        sx3 = sx2;
        sx2 = sx1;
        sx1 = sx0;
        sy9 = sy8;
        sy8 = sy7;
        sy7 = sy6;
        sy6 = sy5;
        sy5 = sy4;
        sy4 = sy3;
        sy2 = sy2;
        sy2 = sy1;
        sy1 = sy0;    
        
        sx0 = sx0 + 1;
        sy0 = sy0;
    }
    if (input_check == Button_left){
        sx9 = sx8;
        sx8 = sx7;
        sx7 = sx6;
        sx6 = sx5;
        sx5 = sx4;
        sx4 = sx3;
        sx3 = sx2;
        sx2 = sx1;
        sx1 = sx0;
        sy9 = sy8;
        sy8 = sy7;
        sy7 = sy6;
        sy6 = sy5;
        sy5 = sy4;
        sy4 = sy3;
        sy2 = sy2;
        sy2 = sy1;
        sy1 = sy0;    
        
        sx0 = sx0 + 1;
        sy0 = sy0;
    }
    if (sy0 == 0)
    {
        sy0 = 41;
    }
    if (sy0 == 42)
    {
        sy0 = 1;
    }
    if (sx0 == 0)
    {
        sy0 = 83;
    }
    if (sx0 == 84)
    {
        sy0 = 1;
    }
}
 
 void Body::trail_delete(N5110 &lcd)
 {
    lcd.setPixel(sx9,sy9,false);
}   
    