/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Jahanzeb Ahmed Khan
Username:el19jak
Student ID Number:201375614
Date:30 May 2020
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "body.h"
#include "food.h"
#include "functions.h"


// objects
Gamepad pad;
N5110 lcd;
Food food;
Body body;
Functions functions;

void visual();
void start();
void init();
void snake_refresh();

int main()
{
    init();
    start();
    
    for (;;) 
    {
        snake_refresh();
        body.game_end(lcd);
        body.food_eaten(lcd, pad, food);
        food.food_location(lcd);
        body.visual(lcd, pad, food);
        functions.output_score(lcd, pad, body, food);
        
        wait(0.02);
        
    }
}

void init()
{
    lcd.init();
    pad.init();
    body.init();
    food.init();
        
}

void snake_refresh()
{
    body.user_input(pad);
    body.trail_delete(lcd);
    body.movement();
}

void start()
{
    while (pad.A_held() == 0)
    {
        lcd.setContrast(0.5);
        lcd.drawCircle(42,24,22,FILL_TRANSPARENT);
        lcd.printString("Welcome to Snake",25,2);
        lcd.printString("Hold A to start",26,4);
        pad.tone(1500.0,1);
        wait(0.5);
        pad.tone(750.0,1);
        wait(0.5);/**Startup tone*/
        pad.tone(1500.0,1);
        wait(0.5);
        pad.tone(750.0,1);
        
        lcd.refresh();
    }
}
    
