#ifndef BODY_H
#define BODY_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "food.h"

class Body
{
    
public:
    
    /** Constructor */
    Body();
    
    /** Destructor */
    ~Body();
    
    /** Initialises body of snake */
    void init();
    
    /** checks if user has lost the game */
    void game_end(N5110 &lcd);
    
    /** removes the historical location of pixels to depict movement */
    void trail_delete(N5110 &lcd);
    
    /** takes input from userfor movement */
    void user_input(Gamepad &pad);
    
    /** alters direction of snake based on input */
    void movement();
    
    /** sets a visual verson of the snake on the pad */
    void visual(N5110 &lcd, Gamepad &pad, Food &food);
    
    /** checks if previous food has been consumed */
    void food_eaten(N5110 &lcd, Gamepad &pad, Food &food);
    
    
    /** defines button input on gamepad */
    enum Input {
        Button_top,
        Button_bottom,
        Button_right,
        Button_left,
    };
    
    int score_display();
    int score;
    
    bool endgame_check();
    bool endgame;
    
    int sx0;
    int sx1;
    int sx2;
    int sx3;
    int sx4;
    int sx5;
    int sx6;
    int sx7;
    int sx8;
    int sx9;
    int sy0;
    int sy1;
    int sy2;
    int sy3;
    int sy4;
    int sy5;
    int sy6;
    int sy7;
    int sy8;
    int sy9;
    
    Input input_check;
    
private:


};

#endif
    
    
    
    
    
    
    