/* University of York Robotics Laboratory Robot Arm Controller Board
 * 
 * Robot Arm Remote Control
 *
 * File: remote.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * 
 * James Hilder, Alan Millard, Shuhei Miyashita, Homero Elizondo, Jon Timmis
 *
 * February 2017, Version 1.0
 *
 */ 


#ifndef REMOTE_H
#define REMOTE_H

/** Remote Class
 * The Remote controller class
 *
 * Example code for main.cpp:
 * @code
 * #include "robotarm.h"
 * Robotarm arm;
 * int main(){
 *    arm.init();
 *    while(1) { //Do something!
 *    }
 * }
 * @endcode
 */
class Remote
{
public:
    /**
     * Main initialisation routine for the robot arm
     *
     * Set up the display, set up listener for remote control, set up servos
     */
    void init(void);
    
    /**
     * Set the LED on the remote
     * param: mode 0=off 1=red 2=green 3=both
     */
    void set_led(char mode);
    
    /**
     * Detect if remote has been attached or detached
     */
    void detect_remote(void);
    
    /**
     * Detect if a direction switch is being pressed
     */
    void detect_direction(void);
    
    /**
     * Move the servo based on controller position
     */
    void move_servo(char servo_number, int adjust);

    
};
#endif // REMOTE_H

/*
 * Copyright 2017 University of York
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and limitations under the License.
 *
 */