/*******************************************************************************************
 *
 * University of York Robot Lab Pi Swarm Robot Library
 *
 * User Command RF Test Program
 *
 * Based on the blank program for 0.6 API, this adds handling for user RF messages from the
 * table controller
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 * 
 * Version 0.6  May 2014
 *
 * Designed for use with the Pi Swarm Board (enhanced MBED sensor board) v1.2
 *
 ******************************************************************************************/

#include "main.h"   // Certain parameters can be set by changing the defines in piswarm.h


PiSwarm piswarm;
Serial pc (USBTX,USBRX);
Timeout clear_screen_timeout;

//This is where the program code goes.  In the simple demo, the outer LEDs are blinked.
int main() {
    init();
    int step = 0;
    int function = 0;
    //Each RF message will contain 1 byte: in this case the user ID.  (Note it is note strictly necessary as the
    //user ID is already sent seperately and we are also sending the 4-bit function register, so for very simple
    //comms the message part can be omitted.)
    char message [2];
    message[0] = piswarm.get_id() + 48;
    
    while(1) {
        step ++;
        //Every 6 steps (1.5 seconds) send an RF message, incrementing the function counter
        if(step==6){
            step=0;
            function ++;
            if(function == 16) function = 0;
            broadcast_user_rf_command(function,message,1);
        }
        switch (step%3){
            case 0:  piswarm.set_oled_colour(50,0,0); break;
            case 1:  piswarm.set_oled_colour(0,50,0); break;
            case 2:  piswarm.set_oled_colour(0,0,50); break;
        }
        switch (step%2){
            case 0:  piswarm.set_oleds(1,0,1,0,1,0,1,0,1,0); break;
            case 1:  piswarm.set_oleds(0,1,0,1,0,1,0,1,0,1); break;
        }
        wait(0.25);
    }
}

// This function is used to send the RF message:
void broadcast_user_rf_command(int function, char * message, int length)
{
    //This function augments the communications stack
    //It sends a 'user' RF command to all members (ie target_id = 0)
    //It sends a 'request', not a 'command', meaning it will still be handled if commands are disabled (RF_ALLOW_COMMANDS set to 0, recommended)
    //It takes three inputs:
    // * function (an integer from 0 to 15)
    // * message  (a char array)
    // * length   (length of message in bytes)
    send_rf_message(0,48+(function % 16),message,length);
}

void clear_screen(){
    piswarm.cls();   
}

/***************************************************************************************************************************************
 *
 * Beyond this point, empty code blocks for optional functions is given
 *
 * These may be left blank if not used, but should not be deleted 
 *
 **************************************************************************************************************************************/
 
// Communications

// If using the communication stack (USE_COMMUNICATION_STACK = 1), functionality for handling user RF responses should be added to the following functions
// If the communication stack is not being used, all radio data is sent to processRawRFData() instead

void handleUserRFCommand(char sender, char broadcast_message, char request_response, char id, char is_command, char function, char * data, char length){
    piswarm.cls();
    piswarm.locate(0,0);
    piswarm.printf("URF:%d",function);
    if(length > 0) {
        piswarm.locate(0,1);
        piswarm.printf("%s",data);   
    }
    clear_screen_timeout.attach(&clear_screen,0.2);
    // A 'user' RF Command has been received:  write the code here to process it
    // sender = ID of the sender, range 0 to 31
    // broadcast_message = 1 is message sent to all robots, 0 otherwise
    // request_response = 1 if a response is expected, 0 otherwise
    // id = Message ID, range 0 to 255
    // is_command = 1 is message is a command, 0 if it is a request.  If RF_ALLOW_COMMANDS is not selected, only requests will be sent to this block
    // function = The function identifier.  Range 0 to 15
    // * data = Array containing extra data bytes
    // length = Length of extra data bytes held (range 0 to 57)

    //Do something...
}    

void handleUserRFResponse(char sender, char broadcast_message, char success, char id, char is_command, char function, char * data, char length){
    //pc.printf("Response:%s\n",data);
    // A 'user' RF Response has been received:  write the code here to process it
    // sender = ID of the sender, range 0 to 31
    // broadcast_message = 1 is message sent to all robots, 0 otherwise
    // success = 1 if operation successful, 0 otherwise
    // id = Message ID, range 0 to 255
    // is_command = 1 is message is a command, 0 if it is a request.  If RF_ALLOW_COMMANDS is not selected, only requests will be sent to this block
    // function = The function identifier.  Range 0 to 15
    // * data = Array containing extra data bytes
    // length = Length of extra data bytes held (range 0 to 57)

    //Do something...  
}    

void processRawRFData(char * rstring, char cCount){
    // A raw RF packet has been received: write the code here to process it
    // rstring = The received packet
    // cCount = Packet length
    
    //Do something...
}

void switch_pressed() {
    //Switch(es) pressed {1 = Center  2 = Right  4 = Left  8 = Down  16 = Up}
    char switches = piswarm.get_switches();
  
    //Do something...
}
