/*******************************************************************************************
 *
 * University of York Robot Lab Pi Swarm Handheld Controller Software
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 *
 * Version 0.5  February 2014
 *
 * Designed for use with the Pi Swarm Board (enhanced MBED sensor board) v1.2
 *
 ******************************************************************************************/

#include "mbed.h"
#include "main.h"
#include "communications.h"
#include "display.h"

Serial pc (USBTX, USBRX);
DigitalOut myled(LED1);
Display display;
Alpha433 rf;
Ticker switch_ticker;
DigitalIn switch_up(p21);
DigitalIn switch_upright(p22);
DigitalIn switch_right(p23);
DigitalIn switch_downright(p24);
DigitalIn switch_down(p25);
DigitalIn switch_downleft(p26);
DigitalIn switch_left(p27);
DigitalIn switch_upleft(p29);
DigitalIn switch_center(p28);
DigitalOut tx_led(p18);
DigitalOut rx_led(p17);
char target_id = 0;
int switch_state = 0;
int speed_mode = 0;
float speed = 0.1;

void handleUserRFCommand(char sender, char broadcast_message, char request_response, char id, char is_command, char function, char * data, char length){
    // A 'user' RF Command has been received:  write the code here to process it
    // sender = ID of the sender, range 0 to 31
    // broadcast_message = 1 is message sent to all robots, 0 otherwise
    // request_response = 1 if a response is expected, 0 otherwise
    // id = Message ID, range 0 to 255
    // is_command = 1 is message is a command, 0 if it is a request.  If RF_ALLOW_COMMANDS is not selected, only requests will be sent to this block
    // function = The function identifier.  Range 0 to 15
    // * data = Array containing extra data bytes
    // length = Length of extra data bytes held (range 0 to 57)
    
}    

void handleUserRFResponse(char sender, char broadcast_message, char success, char id, char is_command, char function, char * data, char length){
    // A 'user' RF Response has been received:  write the code here to process it
    // sender = ID of the sender, range 0 to 31
    // broadcast_message = 1 is message sent to all robots, 0 otherwise
    // success = 1 if operation successful, 0 otherwise
    // id = Message ID, range 0 to 255
    // is_command = 1 is message is a command, 0 if it is a request.  If RF_ALLOW_COMMANDS is not selected, only requests will be sent to this block
    // function = The function identifier.  Range 0 to 15
    // * data = Array containing extra data bytes
    // length = Length of extra data bytes held (range 0 to 57)
  
}    


void processRawRFData(char * rstring, char cCount){
    // A raw RF packet has been received: write the code here to process it
    // rstring = The received packet
    // cCount = Packet length
}

void check_switch()
{
    int new_state = 0;
    if(!switch_up) new_state = 1;
    if(!switch_upright) new_state = 2;
    if(!switch_right) new_state = 3;
    if(!switch_downright) new_state=4;
    if(!switch_down) new_state=5;
    if(!switch_downleft) new_state=6;
    if(!switch_left) new_state=7;
    if(!switch_upleft) new_state=8;
    if(!switch_center) new_state=9;
    if(new_state!=switch_state) {
        switch_state=new_state;
        display.set_position(0,8);
        switch(switch_state) {
            case 0:
                display.printf("          ");
                break;
            case 1:
                display.printf("UP        ");
                break;
            case 2:
                display.printf("UP-RIGHT  ");
                break;
            case 3:
                display.printf("RIGHT     ");
                break;
            case 4:
                display.printf("DOWN-RIGHT");
                break;
            case 5:
                display.printf("DOWN      ");
                break;
            case 6:
                display.printf("DOWN-LEFT ");
                break;
            case 7:
                display.printf("LEFT      ");
                break;
            case 8:
                display.printf("UP-LEFT   ");
                break;
            case 9:
                display.printf("CENTER    ");
                speed_mode ++;
                if (speed_mode == 4) speed_mode = 0;
                switch(speed_mode){
                    case 0: speed = 0.1;break;
                    case 1: speed = 0.2;break;
                    case 2: speed = 0.5;break;
                    case 3: speed = 1.0;break;   
                }
                display.set_position(1,0);
                display.printf("Speed: %.1f",speed);
                break;
        }
        transmit_message();
    }
}

void transmit_message()
{
    tx_led = 1;
    switch(switch_state){
        case 0: send_rf_command_stop(target_id,1);break;
        case 1: send_rf_command_forward(target_id,1,speed);break;
        case 5: send_rf_command_backward(target_id,1,speed);break;
        case 7: send_rf_command_left(target_id,1,speed);break;
        case 3: send_rf_command_right(target_id,1,speed);break;
        case 9: send_rf_message(target_id,0x32,"Hello",5);break;
    }
    wait(0.1);
    tx_led=0;
}

int main()
{
    pc.baud(PC_BAUD);
    display.init_display();
    display.printf("YORK ROBOTICS LAB   PI-SWARM CONTROLLER Software 0.5");
    wait(2.0);
    display.clear_display();
    display.printf("Command:");
    rf.rf_init();
    rf.setFrequency(435000000);
    rf.setDatarate(57600);
    setup_switches();
    switch_ticker.attach( &check_switch , 0.05 );
    while(1) {
        myled = 1;
        // rx_led=1;
        // tx_led=0;
        wait(0.5);
        // rx_led=0;
        // tx_led=1;
        myled = 0;
        wait(0.5);
    }

}

void setup_switches()
{
    switch_center.mode(PullUp);
    switch_up.mode(PullUp);
    switch_upleft.mode(PullUp);
    switch_left.mode(PullUp);
    switch_downleft.mode(PullUp);
    switch_down.mode(PullUp);
    switch_downright.mode(PullUp);
    switch_right.mode(PullUp);
    switch_upright.mode(PullUp);
}


void handleData(char * data, char length)
{
    display.set_position(1,1);
    display.write_string(data,length);
}
