/* University of York Robotics Laboratory MBED Library: Display Driver
 * 
 * File: display.h
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 * 
 * October 2013
 *
 * Driver for the Midas 20x4 I2C LCD Display (MCCOG42005A6W-BNMLWI) LCD
 *
 * Farnell part 2218946 
 *
 */ 
 
#ifndef DISPLAY_H
#define DISPLAY_H

//
// Defines
//

#define LCD_ADDRESS 0x78

class Display : public Stream {

// Public Functions

public:

   /** Create the LCD Display object connected to the default pins
     *
     * @param sda pin   - default is p9
     * @param scl pin   - default is p10
     * @param reset pin - default is p12
     */
     
    Display();
    
    /** Create the LCD Display object connected to specific pins
     *
     */
    Display(PinName sda, PinName scl, PinName reset);

//Print string message of given length
void write_string(char * message, char length);

//Set the row and column of cursor position
void set_position(char row, char column);

// Enable or disable cursor
void set_cursor(char enable);

// Enable or disable cursor blink
void set_blink(char enable);

// Enable or disable display
void set_display(char enable);


// Clear display
void clear_display();

//Set cursor to home position
void home();


// Send a 1-byte control message to the display
int i2c_message(char byte);

// Default initialisation sequence for the display
void init_display();

int disp_putc(int c);


private :

    I2C _i2c;
    DigitalOut _reset;
    
    char display_on;
    char cursor_on;
    char blink_on;
    
    void _set_display();
    
    virtual int _putc(int c);
    virtual int _getc();
    
};

#endif // DISPLAY_H

 
 
/* Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */