#include "robotarm.h"

Robotarm arm;

int main()
{
    wait(1); // Useful if you need to connect H-Term etc.
    //Run the main initialisation routine
    arm.init();
    //Reset the servos to center position (after 1 second delay)
    //NB This activates the servos (makes rigid) so be careful when using
    arm.zero_servos(1);
    //Wait till servos are zeroed
    wait(3);
    //Initialise remote control
    if(REMOTE_ENABLED == 1)remote.init();
    
    //User code can now go in a loop:
    while(1) {
        //Eg set all servos to 1948 then 2148
          servo.SetGoal(BASE,1948,1);
          servo.SetGoal(SHOULDER,1948,1);
          servo.SetGoal(ELBOW,1948,1);
          servo.SetGoal(WRIST,400,1);
            //If you want to show detailed info about a servo over serial, use the following:
            //servo.DebugData(WRIST);
          wait(0.5);
          servo.SetGoal(BASE,2148,1);
          servo.SetGoal(SHOULDER,2148,1);
          servo.SetGoal(ELBOW,2148,1);
          servo.SetGoal(WRIST,600,1);
          wait(0.5);
            //Alternatively we can set all the servos then use trigger - observe the difference...
            //servo.SetGoal(BASE,2148,0);
            //servo.SetGoal(SHOULDER,2148,0);
            //servo.SetGoal(ELBOW,2148,0);
            //servo.SetGoal(WRIST,600,0);
            //servo.trigger();
            //wait(0.5);
    }
}