// Dynamixel MX-28 Demo Code

#include "servo.h"
#include "mbed.h"
#include "SerialHalfDuplex.h"

Serial pc(USBTX,USBRX);
Servo servo(p9,p10);

int main()
{
    pc.baud(115200);
    pc.printf("Dynamixel MX-28 Servo Demo\n");
    int model = servo.GetModelNumber(1);
    if(model != MX28_MODEL) {
        pc.printf("Error: No MX-28 servo with ID 1 found...\n");
        while(1);
    }
    while(1){
        pc.printf("Set servo position to 1024");
        servo.SetGoal(1,1024,1);
        wait(1);   
        pc.printf("Set servo position to 2048");
        servo.SetGoal(1,2048,1);
        wait(1); 
        pc.printf("Set servo position to 3072");
        servo.SetGoal(1,3072,1);
        wait(1);   
        pc.printf("Set servo position to 2048");
        servo.SetGoal(1,2048,1);
        wait(1); 
    }
}