/* University of York Robotics Laboratory PsiSwarm Library: PsiSwarm Core Header File
 * 
 * File: psiswarm.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Homero Elizondo, Jon Timmis
 * 
 * PsiSwarm Library Version: 0.3
 *
 * October 2015
 *
 */ 

#ifndef PSISWARM_H
#define PSISWARM_H
  
#define SOFTWARE_VERSION_CODE 0.20

#define PIC_ADDRESS 0x30
#define LCD_ADDRESS 0x7C 
#define LED_IC_ADDRESS 0x42
#define GPIO_IC_ADDRESS 0x40
#define AUX_IC_ADDRESS 0x4E
#define ADC1_ADDRESS 0x46
#define ADC2_ADDRESS 0x48
#define EEPROM_ADDRESS 0XA0
#define TEMPERATURE_ADDRESS 0X30
#define BASE_COLOUR_ADDRESS 0X52
#define TOP_COLOUR_ADDRESS 0X72
#define ULTRASONIC_ADDRESS 0XE0
#define COMMAND_MESSAGE_BYTE 0X1D
#define ACKNOWLEDGE_MESSAGE_BYTE 0X1E
#define RESPONSE_MESSAGE_BYTE 0X1F
#define PSI_BYTE 0X1D

//Set temperature sensor warnings: 60C critical, 50C high, 0C low
#define TEMPERATURE_CRITICAL_HI 0X03
#define TEMPEARTURE_CRITICAL_LO 0XC0
#define TEMPERATURE_HIGH_HI 0X03
#define TEMPEARTURE_HIGH_LO 0X20
#define TEMPERATURE_LOW_HI 0X00
#define TEMPEARTURE_LOW_LO 0X00

#define DEFAULT_IR_PULSE_DELAY 400
#define DEFAULT_BASE_IR_PULSE_DELAY 50

#include <stdio.h>
#include <stdarg.h>

#include "settings.h"
#include "serial.h"
#include "mbed.h"
#include "display.h"
#include "led.h"
#include "i2c.h"
#include "motors.h"
#include "sensors.h"
#include "eprom.h"
#include "colour.h"
#include "pic.h"
#include "demo.h"
#include "dances.h"

//NB The user needs to have a main.cpp with a main() function and a handle_switch_event(char) function
#include "main.h"


void init(void);
float get_uptime(void);
void pause_user_code(float period);
void reset_encoders(void);
void debug(const char* format, ...) ;

void IF_end_pause_user_code(void);
void IF_handle_events(void);
void IF_update_encoders(void);
void IF_update_user_id(void);
void IF_update_switch(void);
void IF_update_minutes(void);

extern char * program_name;
extern char * author_name;
extern char * version_name;

extern Serial pc;
extern Serial bt;
extern Display display;
extern I2C primary_i2c;
extern InterruptIn gpio_interrupt;

extern AnalogIn vin_current;
extern AnalogIn vin_battery;
extern AnalogIn vin_dc;

extern DigitalOut mbed_led1;
extern DigitalOut mbed_led2;
extern DigitalOut mbed_led3;
extern DigitalOut mbed_led4;
extern PwmOut center_led_red;
extern PwmOut center_led_green;
extern PwmOut motor_left_f;
extern PwmOut motor_left_r;
extern PwmOut motor_right_f;
extern PwmOut motor_right_r;

extern char time_based_motor_action;

extern int base_colour_sensor_raw_values [];
extern int top_colour_sensor_raw_values [];

extern char waiting_for_ultrasonic;
extern int ultrasonic_distance;
extern char ultrasonic_distance_updated;
extern Timeout ultrasonic_timeout;
extern Ticker ultrasonic_ticker;

extern unsigned short background_ir_values [];
extern unsigned short illuminated_ir_values [];
extern float reflected_ir_distances [];
extern char ir_values_stored;

extern char firmware_bytes[];

extern char testing_voltage_regulators_flag;
extern char power_good_motor_left;
extern char power_good_motor_right;
extern char power_good_infrared;
extern char status_dc_in;
extern char status_charging;

extern unsigned short background_base_ir_values [];
extern unsigned short illuminated_base_ir_values [];
extern char base_ir_values_stored;
extern float line_position;
extern char line_found;

extern float motor_left_speed;
extern float motor_right_speed;
extern char motor_left_brake;
extern char motor_right_brake;

extern float center_led_brightness;
extern float backlight_brightness;

extern float firmware_version;

extern int ir_pulse_delay;
extern int base_ir_pulse_delay;

extern char robot_id;
extern char previous_robot_id;

extern char wheel_encoder_byte;
extern char previous_wheel_encoder_byte;
extern signed int left_encoder;
extern signed int right_encoder;

extern char switch_byte;
extern char previous_switch_byte;

extern char user_code_running;
extern char user_code_restore_mode;
extern char demo_on;
extern char event;
extern char change_id_event;
extern char encoder_event;
extern char switch_event;
extern char system_warnings;

extern char debug_mode;
extern char debug_output;
#endif
