#include "mbed.h"
#include "figures.h"
//#include <pcd8544_drv.hpp>

/*
This Code has extra features
including a XY positioning function on Display
and a Line Draw function on Nokia 3310 LCD
It is modded from the original
http://www.arduino.cc/playground/Code/PCD8544
*/
// Mods by Jim Park
// jim(^dOt^)buzz(^aT^)gmail(^dOt^)com
// hope it works for you
DigitalOut PIN_SCE(p26);//p21);  // 7  // LCD CS  .... Pin 3
DigitalOut PIN_RESET(p27);//p22);// 6  // LCD RST .... Pin 1
DigitalOut PIN_DC(p28);//p23);   //  5  // LCD Dat/Com. Pin 5
DigitalOut PIN_SDIN(p29);//p24); //  4  // LCD SPIDat . Pin 6
DigitalOut PIN_SCLK(p30);//p25); //  3  // LCD SPIClk . Pin 4
// LCD Gnd .... Pin 2
// LCD Vcc .... Pin 8
// LCD Vlcd ... Pin 7
DigitalOut PIN_BCKL(p25);//Nokia 5110 backligth


#define LCD_C     0
#define LCD_D     1

#define LCD_X     84
#define LCD_Y     48
#define LCD_CMD   0

#define YMAX 48
#define XMAX 84
int bufferLcd[XMAX][YMAX]={0};

#define byte char
// Function prototype
void LcdWrite(char dc, char data);
void shiftOut(DigitalOut dataPin,DigitalOut clockPin,char bitOrder, char value );
#define MSBFIRST 1
#define LSBFIRST 0

int a = 0;

static const char ASCII[][5] = {
    {0x00, 0x00, 0x00, 0x00, 0x00} // 20
    ,{0x00, 0x00, 0x5f, 0x00, 0x00} // 21 !
    ,{0x00, 0x07, 0x00, 0x07, 0x00} // 22 "
    ,{0x14, 0x7f, 0x14, 0x7f, 0x14} // 23 #
    ,{0x24, 0x2a, 0x7f, 0x2a, 0x12} // 24 $
    ,{0x23, 0x13, 0x08, 0x64, 0x62} // 25 %
    ,{0x36, 0x49, 0x55, 0x22, 0x50} // 26 &
    ,{0x00, 0x05, 0x03, 0x00, 0x00} // 27 '
    ,{0x00, 0x1c, 0x22, 0x41, 0x00} // 28 (
    ,{0x00, 0x41, 0x22, 0x1c, 0x00} // 29 )
    ,{0x14, 0x08, 0x3e, 0x08, 0x14} // 2a *
    ,{0x08, 0x08, 0x3e, 0x08, 0x08} // 2b +
    ,{0x00, 0x50, 0x30, 0x00, 0x00} // 2c ,
    ,{0x08, 0x08, 0x08, 0x08, 0x08} // 2d -
    ,{0x00, 0x60, 0x60, 0x00, 0x00} // 2e .
    ,{0x20, 0x10, 0x08, 0x04, 0x02} // 2f /
    ,{0x3e, 0x51, 0x49, 0x45, 0x3e} // 30 0
    ,{0x00, 0x42, 0x7f, 0x40, 0x00} // 31 1
    ,{0x42, 0x61, 0x51, 0x49, 0x46} // 32 2
    ,{0x21, 0x41, 0x45, 0x4b, 0x31} // 33 3
    ,{0x18, 0x14, 0x12, 0x7f, 0x10} // 34 4
    ,{0x27, 0x45, 0x45, 0x45, 0x39} // 35 5
    ,{0x3c, 0x4a, 0x49, 0x49, 0x30} // 36 6
    ,{0x01, 0x71, 0x09, 0x05, 0x03} // 37 7
    ,{0x36, 0x49, 0x49, 0x49, 0x36} // 38 8
    ,{0x06, 0x49, 0x49, 0x29, 0x1e} // 39 9
    ,{0x00, 0x36, 0x36, 0x00, 0x00} // 3a :
    ,{0x00, 0x56, 0x36, 0x00, 0x00} // 3b ;
    ,{0x08, 0x14, 0x22, 0x41, 0x00} // 3c <
    ,{0x14, 0x14, 0x14, 0x14, 0x14} // 3d =
    ,{0x00, 0x41, 0x22, 0x14, 0x08} // 3e >
    ,{0x02, 0x01, 0x51, 0x09, 0x06} // 3f ?
    ,{0x32, 0x49, 0x79, 0x41, 0x3e} // 40 @
    ,{0x7e, 0x11, 0x11, 0x11, 0x7e} // 41 A
    ,{0x7f, 0x49, 0x49, 0x49, 0x36} // 42 B
    ,{0x3e, 0x41, 0x41, 0x41, 0x22} // 43 C
    ,{0x7f, 0x41, 0x41, 0x22, 0x1c} // 44 D
    ,{0x7f, 0x49, 0x49, 0x49, 0x41} // 45 E
    ,{0x7f, 0x09, 0x09, 0x09, 0x01} // 46 F
    ,{0x3e, 0x41, 0x49, 0x49, 0x7a} // 47 G
    ,{0x7f, 0x08, 0x08, 0x08, 0x7f} // 48 H
    ,{0x00, 0x41, 0x7f, 0x41, 0x00} // 49 I
    ,{0x20, 0x40, 0x41, 0x3f, 0x01} // 4a J
    ,{0x7f, 0x08, 0x14, 0x22, 0x41} // 4b K
    ,{0x7f, 0x40, 0x40, 0x40, 0x40} // 4c L
    ,{0x7f, 0x02, 0x0c, 0x02, 0x7f} // 4d M
    ,{0x7f, 0x04, 0x08, 0x10, 0x7f} // 4e N
    ,{0x3e, 0x41, 0x41, 0x41, 0x3e} // 4f O
    ,{0x7f, 0x09, 0x09, 0x09, 0x06} // 50 P
    ,{0x3e, 0x41, 0x51, 0x21, 0x5e} // 51 Q
    ,{0x7f, 0x09, 0x19, 0x29, 0x46} // 52 R
    ,{0x46, 0x49, 0x49, 0x49, 0x31} // 53 S
    ,{0x01, 0x01, 0x7f, 0x01, 0x01} // 54 T
    ,{0x3f, 0x40, 0x40, 0x40, 0x3f} // 55 U
    ,{0x1f, 0x20, 0x40, 0x20, 0x1f} // 56 V
    ,{0x3f, 0x40, 0x38, 0x40, 0x3f} // 57 W
    ,{0x63, 0x14, 0x08, 0x14, 0x63} // 58 X
    ,{0x07, 0x08, 0x70, 0x08, 0x07} // 59 Y
    ,{0x61, 0x51, 0x49, 0x45, 0x43} // 5a Z
    ,{0x00, 0x7f, 0x41, 0x41, 0x00} // 5b [
    ,{0x02, 0x04, 0x08, 0x10, 0x20} // 5c &#65533;
    ,{0x00, 0x41, 0x41, 0x7f, 0x00} // 5d ]
    ,{0x04, 0x02, 0x01, 0x02, 0x04} // 5e ^
    ,{0x40, 0x40, 0x40, 0x40, 0x40} // 5f _
    ,{0x00, 0x01, 0x02, 0x04, 0x00} // 60 `
    ,{0x20, 0x54, 0x54, 0x54, 0x78} // 61 a
    ,{0x7f, 0x48, 0x44, 0x44, 0x38} // 62 b
    ,{0x38, 0x44, 0x44, 0x44, 0x20} // 63 c
    ,{0x38, 0x44, 0x44, 0x48, 0x7f} // 64 d
    ,{0x38, 0x54, 0x54, 0x54, 0x18} // 65 e
    ,{0x08, 0x7e, 0x09, 0x01, 0x02} // 66 f
    ,{0x0c, 0x52, 0x52, 0x52, 0x3e} // 67 g
    ,{0x7f, 0x08, 0x04, 0x04, 0x78} // 68 h
    ,{0x00, 0x44, 0x7d, 0x40, 0x00} // 69 i
    ,{0x20, 0x40, 0x44, 0x3d, 0x00} // 6a j
    ,{0x7f, 0x10, 0x28, 0x44, 0x00} // 6b k
    ,{0x00, 0x41, 0x7f, 0x40, 0x00} // 6c l
    ,{0x7c, 0x04, 0x18, 0x04, 0x78} // 6d m
    ,{0x7c, 0x08, 0x04, 0x04, 0x78} // 6e n
    ,{0x38, 0x44, 0x44, 0x44, 0x38} // 6f o
    ,{0x7c, 0x14, 0x14, 0x14, 0x08} // 70 p
    ,{0x08, 0x14, 0x14, 0x18, 0x7c} // 71 q
    ,{0x7c, 0x08, 0x04, 0x04, 0x08} // 72 r
    ,{0x48, 0x54, 0x54, 0x54, 0x20} // 73 s
    ,{0x04, 0x3f, 0x44, 0x40, 0x20} // 74 t
    ,{0x3c, 0x40, 0x40, 0x20, 0x7c} // 75 u
    ,{0x1c, 0x20, 0x40, 0x20, 0x1c} // 76 v
    ,{0x3c, 0x40, 0x30, 0x40, 0x3c} // 77 w
    ,{0x44, 0x28, 0x10, 0x28, 0x44} // 78 x
    ,{0x0c, 0x50, 0x50, 0x50, 0x3c} // 79 y
    ,{0x44, 0x64, 0x54, 0x4c, 0x44} // 7a z
    ,{0x00, 0x08, 0x36, 0x41, 0x00} // 7b {
    ,{0x00, 0x00, 0x7f, 0x00, 0x00} // 7c |
    ,{0x00, 0x41, 0x36, 0x08, 0x00} // 7d }
    ,{0x10, 0x08, 0x08, 0x10, 0x08} // 7e &#8592;
    ,{0x00, 0x06, 0x09, 0x09, 0x06} // 7f &#8594;
};


/*************************************************************************/
const char *byte_to_binary
(
    int x
)
{
    static char b[9];
    b[0] = '\0';

    int z;
    for (z = 256; z > 0; z >>= 1)
    {
        strcat(b, ((x & z) == z) ? "|" : "0");
    }

    return b;
}
/**********************************************************************************************/

void LcdCharacter(char character) {
    LcdWrite(LCD_D, 0x00);
    for (int index = 0; index < 5; index++) {
        LcdWrite(LCD_D, ASCII[character - 0x20][index]);
    }
    LcdWrite(LCD_D, 0x00);
}

void LcdClear(void) {
    for (int index = 0; index < LCD_X * LCD_Y / 8; index++) {
        LcdWrite(LCD_D, 0x00);
    }
}

void LcdInitialise(void) {
    //pinMode(PIN_SCE,OUTPUT);
    //pinMode(PIN_RESET, OUTPUT);
    //pinMode(PIN_DC,    OUTPUT);
    //pinMode(PIN_SDIN,  OUTPUT);
    //pinMode(PIN_SCLK,  OUTPUT);

    PIN_RESET=0;
    //digitalWrite(PIN_RESET, LOW);

// delay(1);
// wait(0.001);
    PIN_RESET=1;
    //digitalWrite(PIN_RESET, HIGH);

    LcdWrite( LCD_CMD, 0x21 );  // LCD Extended Commands.
    LcdWrite( LCD_CMD, 0xB0 );  // Set LCD Vop (Contrast). //B1 for normal clear background, b2 to bf for dark background
    LcdWrite( LCD_CMD, 0x04 );  // Set Temp coefficent. //0x04
    LcdWrite( LCD_CMD, 0x14 );  // LCD bias mode 1:48. //0x13
    LcdWrite( LCD_CMD, 0x0C );  // LCD in normal mode. 0x0d for inverse
    LcdWrite(LCD_C, 0x20);
    LcdWrite(LCD_C, 0x0C);
}

void LcdString(char *characters) {
    while (*characters) {
        LcdCharacter(*characters++);
    }
}

void LcdWrite(byte dc, byte data) {
    PIN_DC=dc;
    PIN_SCE=0;
    shiftOut(PIN_SDIN, PIN_SCLK, MSBFIRST, data);
    //->wait(0.001);
    PIN_SCE=1;
    /*
    digitalWrite(PIN_DC, dc);
    digitalWrite(PIN_SCE, LOW);
    shiftOut(PIN_SDIN, PIN_SCLK, MSBFIRST, data);
    digitalWrite(PIN_SCE, HIGH);
    */
}

// gotoXY routine to position cursor
// x - range: 0 to 84
// y - range: 0 to 5

void gotoXY(int x, int y) {
    LcdWrite( 0, 0x80 | x);  // Column.
    LcdWrite( 0, 0x40 | y);  // Row.

}



void drawLine(int x0,int y0,//Initial Point
              int x1,int y1)//Final point
{
        int dy = y1 - y0;
        int dx = x1 - x0;
        int stepx, stepy;
        if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }
        dy <<= 1;                 // dy is now 2*dy
        dx <<= 1;                 // dx is now 2*dx
        bufferLcd[x0][y0]=1;
     //   printf("Ini X0,y0=  %2u ,%2u\n", x0,y0);
        if (dx > dy) {
            int fraction = dy - (dx >> 1);// same as 2*dy - dx
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;      // same as fraction -= 2*dx
                }
                x0 += stepx;
                fraction += dy;         // same as fraction -= 2*dy
                bufferLcd[x0][y0]=1;
             //   printf("   X0,y0=  %2u ,%2u\n", x0,y0);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                y0 += stepy;
                fraction += dx;
               bufferLcd[x0][y0]=1;
              // printf("   X0,y0=  %2u ,%2u\n", x0,y0);
            }
        }
        
        // printf("<-------       ------->\n");
        
}

void updateLcd(void) {//Update with data from Buffer(Use drawPoint)
int blockVal;
    for(int x=0;x<XMAX;x++) { //For every value of x
        for(int block=0;block<6;block++) {//For everyone of the 6 block in y.
            blockVal=0;//Initialise to zero value of hte block
            for(int i=0;i<8;i++) {//For every block�s bit
                blockVal|=(bufferLcd[x][(block*8)+i])<<i;//Current block�s bit value is pushed
            }
            //The point is drawed
            gotoXY (x,block);
            LcdWrite (1,blockVal);
            //wait(0.1);
        }
    }
}

void clearLcdBuff() { //Clear the entire buffer (Use drawPoint)

    for(int i=0;i<XMAX;i++) {
        for(int j=0;j<YMAX;j++) {
             bufferLcd[i][j]=0;   
    
        }
    }
/*int blockVal;
    for(int x=0;x<XMAX;x++) {
        for(int block=0;block<5;block++) {
            blockVal=0;

            //The point is drawed
            gotoXY (x,block);
            LcdWrite (1,blockVal);
        }
    }
*/    
}

void drawPoint(int X, int Y) { //drawing point using values  0->83 in X and 0->47 in Y [READ BLOCK THEN add/Modify NEW POINT]
/*int blck,blckPos,buffY;
    //Selection of y block(0->5)
    blck=(int)(floor((y_dbl/8))); //Determining the block
    blckPos=(int)(y%8);//Calculating position in block
    buffY|=1<<blckPos;
*/    
    //The point is stored
     bufferLcd[X][Y]=1;
    
}
void drawPoint_inst(int x, int y) { //drawing point using values  0->83 in X and 0->47 in Y [READ BLOCK THEN add/Modify NEW POINT]
int buf_y=0,blck,blckPos;
double y_dbl;
    y_dbl=(double)(y);
    //Selection of y block(0->5)
    blck=(int)(floor((y_dbl/8))); //Determining the block
    blckPos=(int)(y%8);//Calculating position in block
    buf_y|=1<<blckPos;
    
    //The point is stored
    gotoXY (x,blck);
    LcdWrite (1,buf_y);
    
}
/*
int roundVal(float value ) {//Round point in line
int y;
    if(abs(value-ceil(value))>=abs(value-floor(value))) {
        y=(int)(floor(value));
    }
    else {
        y=(int)(ceil(value));  
    }
    
    return y;                
}
*/
void setup(void) {

    LcdInitialise();
    LcdClear();

}

int main(void) {
    // Display some simple character animation
    //
    int a,b;
    char Str[15];
    int count=0;


    setup();
    //wait(0.1);
    PIN_BCKL=0;
    wait(0.5);
    PIN_BCKL=1;
while(1) {
        printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n");
        for(int a=0;a<504;a++) {
         if((a%84)==0)
            printf("Last frame\n");
         printf("%3u:: %s\n",a,byte_to_binary(MCertified2[a]));
        }
        printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n");
        clearLcdBuff();
        printf("Start---------\n");
        for (int index3 = 0; index3 < 6; index3++) {
            for( int index1= 0; index1 <8; index1++) {
                for( int index2= 0; index2 < 84; index2++) {
                    if((MCertified[(index3*84)+index2]&(1<<index1))!=0) {
                        #ifdef FastLcd
                        bufferLcd[index2][(index3*8)+index1]=1;//(7-index1)]= 1;
                        #endif
                        #ifdef  Bitmap2Lcd
                        bufferLcd[index2][(index3*8)+(7-index1)]= 1;
                        #endif
                        printf("|");
                    }
                    else
                        printf(" ");
                }
                printf("\n");
            }
        }
        printf("\End---------\n");
        updateLcd();
        wait(0.5);
}
    while (1) {
        //gotoXY(0,0);
        count++;
        //LcdString("Hello there esta es una prueba de lcd ");

        //drawLine(1,1,count,47);
        clearLcdBuff();
      /* drawLine(0,0,83,0);
        drawLine(83,0,83,47);
        drawLine(83,47,0,47);
        drawLine(0,47,0,0);
       */ 
       drawLine(0,0,count,47);
        updateLcd();
        wait(0.15);
        LcdClear();
        if (count==83)
            count=0;
    }
    // Draw a Box
// for(b=1000; b>0; b--){
// drawLine();
// for(a=0; a<=5 ; a++){
// gotoXY(4,1);
    // Put text in Box
    LcdString("TestDisplay");
    gotoXY(24,3);
    LcdCharacter('H');
    LcdCharacter('E');
    LcdCharacter('L');
    LcdCharacter('L');
    LcdCharacter('O');
    LcdCharacter(' ');
    LcdCharacter('=');
    // Draw + at this position
    gotoXY(10,3);
    LcdCharacter('=');
    wait(0.5);
    gotoXY(24,3);
    LcdCharacter('h');
    LcdCharacter('e');
    LcdCharacter('l');
    LcdCharacter('l');
    LcdCharacter('o');
    LcdCharacter(' ');
    LcdCharacter('-');
    // Draw - at this position
    gotoXY(10,3);
    LcdCharacter('-');
    wait(0.5);
// }
// }

    while (1);
    return 0;
}

/*
LYBRARIES
*/
//shiftOut(dataPin, clockPin, bitOrder, value)
void shiftOut(DigitalOut dataPin,DigitalOut clockPin,char bitOrder, char value ) {
    int i;
    clockPin=0;
    if (bitOrder==LSBFIRST) {
        for (i=0;i<=7;i++) {
            //dataPin=value&(1>>i);
            dataPin=value&(1);
            value=value>>1;
            clockPin=1;
            //->wait(0.0001);
            clockPin=0;
        }
    } else {
        for (i=7;i>=0;i--) {
            //dataPin=value&(1<<i);
            dataPin=value&(1<<7);
            value=value<<1;
            clockPin=1;
            //->wait(0.0001);
            clockPin=0;
        }
    }

}

