/*
Authors: Jacob Dahleen, Nadiyah Johnson
*/
#include "mbed.h"
#include "C12832.h"
#include <string>

BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
DigitalIn joyUp(p15);
DigitalIn joyDown(p12);
DigitalIn joyLeft(p13);
DigitalIn joyRight(p16);


Serial pc(USBTX, USBRX); // tx, rx
InterruptIn firePress(p14);
Timeout timeout;
bool typing;
bool countdown;
bool gameOver;
int wordCount;

BusOut leds(LED1,LED2,LED3,LED4);
//const int SCREEN_WIDTH = 128;
//const int SCREEN_HEIGHT = 32;

void fireISR() {
    leds=~leds;
    countdown=true;
}

void endGameISR() {
    typing = false;
    gameOver = true;
}

int main()
{
    lcd.cls();
    lcd.printf("hello world");
    char c;
    typing = false;
    countdown = false;
    gameOver = false;
    wordCount = 0;
    int count = 5;
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Press joystick to start test");

    //setup interrupt handlers
    firePress.rise(&fireISR);

    while(1) {
//        if (fire) {
//            leds=0xf;
//        } else {
//            leds=joy;
//        }
        while(countdown){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Start Typing in %d", count);
            count--;
            wait(.5);
            if(0 == count){
                countdown=false;
                typing = true;
                count = 5;
                timeout.attach(&endGameISR,60);
                pc.printf("\r\nStart Typing\r\n");
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Start Typing");
            }
        }
        while(typing){
            c = pc.getc();
            if('\n' == c){
//                lcd.cls();
//                lcd.locate(0,0);
//                lcd.printf("newline");
                pc.putc('\r');
                pc.putc(c);
                wordCount++;
            }
            else if('\r' == c){
//                lcd.cls();
//                lcd.locate(0,0);
//                lcd.printf("slash r");
                pc.putc(c);
                pc.putc('\n');
                wordCount++;
            }
            else if(' ' == c){
                pc.putc(c);
                wordCount++;
            }
            else{
                pc.putc(c);
            }
        }
        if(gameOver){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Words per minute: %d\n", wordCount);
            lcd.printf("Press joystick to start test");
            gameOver = false;
            wordCount = 0;
        }
    }
}