#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"

BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
DigitalIn joyUp(p15); 
DigitalIn joyDown(p12);
DigitalIn joyLeft(p13);
DigitalIn joyRight(p16);
MMA7660 MMA(p28, p27); //I2C Accelerometer
Serial pc(USBTX, USBRX); // tx, rx

BusOut leds(LED1,LED2,LED3,LED4);
int appIndex = 0;
const int NUM_APPS = 4;
bool appSwitch = true;
enum SnakeDirection{RIGHT,LEFT,UP,DOWN};
const int SCREEN_WIDTH = 128;
const int SCREEN_HEIGHT = 32;
struct Point {int x; int y;};
/*
Index   App
0       Etch a sketch
1       Flat Level
2       Snake
3       ?
*/

int main()
{
    //potentiometer variables
    float etchX = 0;
    float etchY = 0;
    //accelerometer variables
    int x=0,y=0;
    //snake variables
    const int SNAKE_MAX = 256;
    Point snake[SNAKE_MAX];
    int snakeHead = 4;//the front filled square in the snake
    int newHead = 0;
    int snakeTail = 0;
    SnakeDirection snakeGo = RIGHT;
    bool gameOver = false;
    int points = 0;
    Point goalLoc;
    
    lcd.cls();
    lcd.printf("hello world");
    
    while(1) {
        if (fire) {
            appIndex = (appIndex+1)%NUM_APPS;
            leds=0xf;
            appSwitch = true;
        }
        else {
            leds=joy;
        }
        
        switch(appIndex) {
            case 0: {
                if(appSwitch){
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Etch-a-Sketch");
                    wait(2);
                    lcd.cls();
                    lcd.locate(0,0);
                    appSwitch=false;
                }
                //read potentiometers in scaled volatge
                etchY = 32-pot1.read()*32;
                etchX = 128-pot2.read()*128;
                lcd.pixel((int)etchX, (int)etchY, 1);
                lcd.copy_to_lcd();
                x = MMA.x();
                y = MMA.y();
                if(x > .9 || x < -.9 || y > .9 || y < -.9){
                    lcd.cls();
                }
                break;}
            case 1: {
                if(appSwitch){
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Flat Level");
                    wait(2);
                    lcd.cls();
                    lcd.locate(0,0);
                    appSwitch=false;
                }
                //read X,Y +/-Gs and scale for #display pixels
                x = (x + MMA.x() * 32.0)/2.0;
                y = (y -(MMA.y() * 16.0))/2.0;
                lcd.fillcircle(x+63, y+15, 3, 1); //draw bubble
                lcd.line(0, 11, 127, 11, 1);
                lcd.line(0, 20, 127, 20, 1);
                lcd.line(59, 0, 59, 31, 1);
                lcd.line(68, 0, 68, 31, 1);
                //lcd.circle(63, 15, 8, 1);
                wait(.2); //time delay
                lcd.fillcircle(x+63, y+15, 3, 0); //erase bubble
                break;}
            case 2: {//snake
                if(appSwitch || gameOver){
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Snake");
                    
                    //setup new snake
                    snakeTail = 0;
                    snakeHead = 4;
                    snakeGo = RIGHT;
                    snake[0].x = 0;
                    snake[0].y = 14;
                    snake[1].x = 2;
                    snake[1].y = 14;
                    snake[2].x = 4;
                    snake[2].y = 14;
                    snake[3].x = 6;
                    snake[3].y = 14;
                    snake[4].x = 8;
                    snake[4].y = 14;
                    gameOver = false;
                    points = 0;
                    float seed = pot1.read()*pot2.read()*100000;
                    srand((int)seed);
                    goalLoc.x = (rand()%64)*2;
                    goalLoc.y = (rand()%16)*2;
                    
                    wait(2);
                    lcd.cls();
                    lcd.locate(0,0);
                    appSwitch=false;
                    
                    //draw initial snake
                    for(int i = 0; i<=snakeHead; i++){
                        lcd.fillrect(snake[i].x, snake[i].y, snake[i].x+1, snake[i].y+1, 1);
                    }
                    //draw initial goal location
                    lcd.fillrect(goalLoc.x, goalLoc.y, goalLoc.x+1, goalLoc.y+1, 1);
                    lcd.copy_to_lcd();
                    
                    //wait for user to see snake before moving
                    wait(1);
                }
                
                //read joystick to get new direction
                if(joyUp && DOWN != snakeGo)
                {snakeGo = UP;}
                if(joyDown && UP != snakeGo)
                {snakeGo = DOWN;}
                if(joyLeft && RIGHT != snakeGo)
                {snakeGo = LEFT;}
                if(joyRight && LEFT != snakeGo)
                {snakeGo = RIGHT;}
                
                //move snake
                switch(snakeGo){
                    case RIGHT:
                        //clear tail
                        lcd.fillrect(snake[snakeTail].x, snake[snakeTail].y, snake[snakeTail].x+1, snake[snakeTail].y+1, 0);
                        snakeTail = (snakeTail+1)%SNAKE_MAX;
                        //draw new front
                        newHead = (snakeHead+1)%SNAKE_MAX;
                        snake[newHead].x = snake[snakeHead].x + 2;
                        snake[newHead].y = snake[snakeHead].y;
                        snakeHead = newHead;
                        lcd.fillrect(snake[snakeHead].x, snake[snakeHead].y, snake[snakeHead].x+1, snake[snakeHead].y+1, 1);
                        //copy to lcd
                        lcd.copy_to_lcd();
                        //check if we went off the screen
                        if(snake[snakeHead].x >= SCREEN_WIDTH){
                            gameOver = true;
                            pc.printf("Off screen to right\r\n");
                            pc.printf("snakeHead:%d x=%d, y=%d",snakeHead,snake[snakeHead].x,snake[snakeHead].y);
                        }
                        break;
                    case LEFT:
                        //clear tail
                        lcd.fillrect(snake[snakeTail].x, snake[snakeTail].y, snake[snakeTail].x+1, snake[snakeTail].y+1, 0);
                        snakeTail = (snakeTail+1)%SNAKE_MAX;
                        //draw new front
                        newHead = (snakeHead+1)%SNAKE_MAX;
                        snake[newHead].x = snake[snakeHead].x - 2;
                        snake[newHead].y = snake[snakeHead].y;
                        snakeHead = newHead;
                        lcd.fillrect(snake[snakeHead].x, snake[snakeHead].y, snake[snakeHead].x+1, snake[snakeHead].y+1, 1);
                        //copy to lcd
                        lcd.copy_to_lcd();
                        //check if we went off the screen
                        if(snake[snakeHead].x < 0){
                            gameOver = true;
                            pc.printf("Off screen to left\r\n");
                            pc.printf("snakeHead:%d x=%d, y=%d",snakeHead,snake[snakeHead].x,snake[snakeHead].y);
                        }
                        break;
                    case UP:
                        //clear tail
                        lcd.fillrect(snake[snakeTail].x, snake[snakeTail].y, snake[snakeTail].x+1, snake[snakeTail].y+1, 0);
                        snakeTail = (snakeTail+1)%SNAKE_MAX;
                        //draw new front
                        newHead = (snakeHead+1)%SNAKE_MAX;
                        snake[newHead].x = snake[snakeHead].x;
                        snake[newHead].y = snake[snakeHead].y - 2;
                        snakeHead = newHead;
                        lcd.fillrect(snake[snakeHead].x, snake[snakeHead].y, snake[snakeHead].x+1, snake[snakeHead].y+1, 1);
                        //copy to lcd
                        lcd.copy_to_lcd();
                        //check if we went off the screen
                        if(snake[snakeHead].y < 0){
                            gameOver = true;
                            pc.printf("Off screen top\r\n");
                            pc.printf("snakeHead:%d x=%d, y=%d",snakeHead,snake[snakeHead].x,snake[snakeHead].y);
                        }
                        //wait?
                        break;
                    case DOWN:
                        //clear tail
                        lcd.fillrect(snake[snakeTail].x, snake[snakeTail].y, snake[snakeTail].x+1, snake[snakeTail].y+1, 0);
                        snakeTail = (snakeTail+1)%SNAKE_MAX;
                        //draw new front
                        newHead = (snakeHead+1)%SNAKE_MAX;
                        snake[newHead].x = snake[snakeHead].x;
                        snake[newHead].y = snake[snakeHead].y + 2;
                        snakeHead = newHead;
                        lcd.fillrect(snake[snakeHead].x, snake[snakeHead].y, snake[snakeHead].x+1, snake[snakeHead].y+1, 1);
                        //copy to lcd
                        lcd.copy_to_lcd();
                        //check if we went off the screen
                        if(snake[snakeHead].y >= SCREEN_HEIGHT){
                            gameOver = true;
                            pc.printf("Off screen bottom\r\n");
                            pc.printf("snakeHead:%d x=%d, y=%d",snakeHead,snake[snakeHead].x,snake[snakeHead].y);
                        }
                        //wait?
                        break;
                }
                //check if we scored a point
                if(snake[snakeHead].x == goalLoc.x && snake[snakeHead].y == goalLoc.y){
                    points++;
                    //clear old goal and set new goal
                    lcd.fillrect(goalLoc.x, goalLoc.y, goalLoc.x+1, goalLoc.y+1, 0);
                    goalLoc.x = (rand()%64)*2;
                    goalLoc.y = (rand()%16)*2;
                    lcd.fillrect(goalLoc.x, goalLoc.y, goalLoc.x+1, goalLoc.y+1, 1);
                    
                    //add on to the tail
                    int newTail = (snakeTail-1+SNAKE_MAX)%SNAKE_MAX;
                    snake[newTail].x = snake[snakeTail].x;
                    snake[newTail].y = snake[snakeTail].y;
                    snakeTail = newTail;
                    
                    //copy everything to the lcd
                    lcd.copy_to_lcd();
                    if(points > SNAKE_MAX-5)
                    {
                        gameOver = true;
                        pc.printf("Game Winner!\r\n");
                    }
                }
                //check if we hit ourself
                int testLimit = snakeHead;
                if(snakeTail > snakeHead){
                    testLimit = snakeHead+SNAKE_MAX;
                }
                for(int i = snakeTail; i < testLimit; i++){
                    int iMod = i%SNAKE_MAX;
                    if(snake[snakeHead].x == snake[iMod].x && snake[snakeHead].y == snake[iMod].y){
                        gameOver = true;
                        pc.printf("Hit Self\r\n");
                        pc.printf("snakeHead:%d x=%d, y=%d",snakeHead,snake[snakeHead].x,snake[snakeHead].y);
                    }
                }
                
                if(gameOver){
                    //lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Game Over, Press Joystick to start over\nPoints Scored: %d",points);
                    pc.printf("Game Over\r\n");
                    while(!fire){
                        //infinite loop to wait for user to press joystick to restart
                    }
                    wait(.5);
                }
                
                break;}
            case 3: {
                if(appSwitch){
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Horizontal Level");
                    wait(2);
                    lcd.cls();
                    lcd.locate(0,0);
                    appSwitch=false;
                }
                break;}
            default: {
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Error: appIndex out of range - appIndes=%d",appIndex);
                break;}
        }
        
        
        wait(0.1);
    }
}