#include "mbed.h"
#include "C12832.h"
#include "mario.h"
#include "lovesme.h"

//#define MASTER
#define SLAVE

BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
PwmOut spkr(p26);
C12832 lcd(p5, p7, p6, p8, p11);
DigitalIn up(p15);
DigitalIn down(p12);
BusOut leds(LED1,LED2,LED3,LED4);

#ifdef MASTER
I2C i2cPort(p9,p10);
#endif
#ifdef SLAVE
I2CSlave slave(p9,p10);
#endif
char note;
char length;
const int slaveAddress = 0x42;
char received = 0;
float waitBase=1;

int main()
{
#ifdef SLAVE
    slave.address(slaveAddress);
#endif
    lcd.cls();
    lcd.printf("hello world");

    while(1) {
        if (fire) {
            leds=0xf;
            waitBase = 60.0/marioTempo;
            for(int i=0;i<(sizeof(marioNotes)/sizeof(NoteName));i++){
                if(marioNotes[i] == R) {
                    spkr=0.0;
                    wait(waitBase*marioBeats[i]/12);
                }
                else{
                    spkr.period(1/(notes[marioNotes[i]]));
                    spkr=.5;
                    wait(waitBase*marioBeats[i]/12);
                    spkr=0.0;
                }
            }
            spkr=0.0;
            //end speaker code
        } else {
            leds=joy;
#ifdef MASTER
            waitBase = 60.0/marioTempo;
            if(up) {
                //master sends its song to slave
                i2cPort.start();
                //send address
                i2cPort.write(slaveAddress);
                //send tempo (BPM)
                //loop through song
                for(int i=0;i<(sizeof(marioNotes)/sizeof(NoteName));i++){
                    if(marioNotes[i] == R) {
                        i2cPort.write(R);
                        spkr=0.0;
                        wait(waitBase*marioBeats[i]/12);
                    }
                    else{
                        i2cPort.write(marioNotes[i]);
                        spkr.period(1/(notes[marioNotes[i]]));
                        spkr=.5;
                        wait(waitBase*marioBeats[i]/12);
                        spkr=0.0;
                    }
                }
                spkr=0.0;
                //send stop code
                i2cPort.write(0xFF);
                wait(.5);
                //close i2c port
                i2cPort.stop();
            } else if(down) {
                //slave should send it's song to master
                i2cPort.start();
                //send address with read command
                i2cPort.write(slaveAddress|0x01);
                
                do {
                    received = i2cPort.read(1);
                    spkr=0.0;
                    if(received == R) {
                        spkr=0.0;
                    }
                    else{
                        spkr.period(1/(notes[received]));
                        spkr=.5;
                    }
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Received: %d",received);
                } while(received != 0xFF);
                
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("done");
                i2cPort.stop();
            }
#endif
#ifdef SLAVE
            waitBase = 60.0/lovesMeTempo;
            received = slave.receive();
            if(I2CSlave::ReadAddressed==received) { //master is requesting slave song
                for(int i=0;i<(sizeof(loveFrequency)/sizeof(NoteName));i++){
                    if(loveFrequency[i] == R) {
                        slave.write(R);
                        spkr=0.0;
                        wait(waitBase*loveBeat[i]/12);
                    }
                    else{
                        slave.write(loveFrequency[i]);
                        spkr.period(1/(notes[loveFrequency[i]]));
                        spkr=.5;
                        wait(waitBase*loveBeat[i]/12);
                        spkr=0.0;
                    }
                }
                spkr=0.0;
                slave.write(0xFF);
                slave.stop();
            }
            else if(I2CSlave::WriteAddressed==received) { //master is sending its song
                do {
                    received = slave.read();
                    spkr=0.0;
                    if(received == R) {
                        spkr=0.0;
                    }
                    else{
                        spkr.period(1/(notes[received]));
                        spkr=.5;
                    }
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Received: %d",received);
                } while(received != 0xFF);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("done");
                slave.stop();
            }
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("%d",received);
#endif
        }
    }
}