#include "mbed.h"
#include "C12832.h"
#include "TimerCB.h"

TimerCB::TimerCB(){
    running = false;
}

int TimerCB::getMinutes(){
    int secs = (int)timer.read();
    int min = secs/60;
    return min;
}

int TimerCB::getSeconds(){
    int secs = (int)timer.read();
    secs = secs%60;
    return secs;
}

int TimerCB::getMS(){
    int millis = timer.read_ms();
    millis = millis%1000;
    return millis;
}

void TimerCB::start(){
    timer.start();
    running = true;
}

void TimerCB::stop(){
    timer.stop();
    running = false;
}

void TimerCB::reset(){
    timer.reset();
    timer.stop();
    running = false;
}

bool TimerCB::isRunning(){
    return running;
}