#include "HallEffect.h"

HallEffect::HallEffect(){
    strokeCount = 0;
    for(int i = 0; i < DATA_STROKE_COUNT; i++){
        timeBetweenStrokes[i] = 1;
    }
    timeIndex = 0;
    timer.start();
}

int HallEffect::getSPM(){
    int spm = -1;
    double sum = 0;
    for(int i = 0; i < DATA_STROKE_COUNT; i++){
        sum += timeBetweenStrokes[i];
    }
    double secPerStroke = (sum * 2) / DATA_STROKE_COUNT;
    double strokesPerSec = 1/secPerStroke;
    double strokesPerMin = strokesPerSec*60;
    spm = (int)strokesPerMin;
    return spm;
}

int HallEffect::getCount(){
    return strokeCount/2;
}

void HallEffect::resetCount(){
    strokeCount = 0;
}

void HallEffect::recordStroke(){
    strokeCount++;
    timer.stop();
    timeBetweenStrokes[timeIndex] = timer.read();
    timer.reset();
    timer.start();
    timeIndex = (timeIndex + 1) % DATA_STROKE_COUNT;
}