#include "mbed.h"
#include <ros.h>
#include <std_msgs/UInt16.h>
#include <rosserial_mbed/Adc.h>

ros::NodeHandle nh;

PinName _LED5 = PD_14;
PinName _ADC0 = PC_0;
PinName _ADC1 = PC_1; 
PinName _ADC2 = PC_5; 
PinName _ADC3 = PA_1; 
PinName _ADC4 = PA_5; 
PinName _ADC5 = PA_7; 
PinName _ADC6 = PC_4; 

DigitalOut myled(_LED5);

rosserial_mbed::Adc adc_msg;
//std_msgs::UInt16 adc_msg;
ros::Publisher chatter("chatter", &adc_msg);

//! Filter by averaging
int averageAnalog(PinName pin) {
    int v=0;
    for (int i=0; i<4; i++) v+= AnalogIn(pin).read_u16();
    return v/4;
}

//char hello[13] = "Hello world!";

int main() {
    nh.initNode();
    nh.advertise(chatter);

    while (1) {
        //! These values were fine tuned for the current state of the hall sensors in the interface...
        adc_msg.adc0 = (uint16_t)((averageAnalog(_ADC0)-11000)*1.3725);
        adc_msg.adc1 = (uint16_t)((averageAnalog(_ADC1)-16000));
        adc_msg.adc2 = (uint16_t)((averageAnalog(_ADC2)-6700)*1.435270);
        adc_msg.adc3 = (uint16_t)((averageAnalog(_ADC3)-15000)*1.94747);
        adc_msg.adc4 = (uint16_t)((averageAnalog(_ADC4)-1300)*1.32646);
        adc_msg.adc5 = (uint16_t)((averageAnalog(_ADC5)-1500)*1.20977);
        adc_msg.adc6 = (uint16_t)((averageAnalog(_ADC6)-6100)*1.289134);       
        chatter.publish(&adc_msg);
        nh.spinOnce();
        wait_ms(10);
    }
}
