#include "ADXL345_I2C.h"
#include "mbed.h"
#include "PololuLedStrip.h"

#define DEBUG

#ifdef DEBUG
#include "USBSerial.h"                       // To use USB virtual serial, a driver is needed, check http://mbed.org/handbook/USBSerial
#define LOG(args...)    pc.printf(args)
USBSerial pc;
#else
#define LOG(args...)
#endif
PololuLedStrip ledStrip(P0_8);
ADXL345_I2C accelerometer(P0_5, P0_4);


#define LED_COUNT 6
rgb_color colors[LED_COUNT];
Timer timer;
rgb_color color;

DigitalOut led_white(P0_23);
DigitalOut led_blue(P0_20);
DigitalOut led_strip(P0_8);
int  x,y,z,val;

rgb_color hsvToRgb(float h, float s, float v)    //claim object hsvToRbg  
{
    int i = floor(h * 6);
    float f = h * 6 - i;
    float p = v * (1 - s);
    float q = v * (1 - f * s);
    float t = v * (1 - (1 - f) * s);
    float r = 0, g = 0, b = 0;
    switch(i % 6){
        case 0: r = v; g = t; b = p; break;
        case 1: r = q; g = v; b = p; break;
        case 2: r = p; g = v; b = t; break;
        case 3: r = p; g = q; b = v; break;
        case 4: r = t; g = p; b = v; break;
        case 5: r = v; g = p; b = q; break;
    }
    return (rgb_color){r * 255, g * 255, b * 255};
}

int main()
{
    
    
    led_white=0;
    led_blue=0;

    int readings[3] = {0, 0, 0};

    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0B);
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setPowerControl(0x08);

    while (1) {
        accelerometer.getOutput(readings);

        x=abs((int16_t)readings[2]);
        y=abs((int16_t)readings[2]);         
        z=abs((int16_t)readings[2]);   
        
        val=x;
        if (val<y)val=y;
        if (val<z)val=z;
        if (val>1100)val=1100;          
                
                if (val>300)
                    {   
                                                    
                     color.red =0;
                     color.green = char((val-300)*255/800); 
                     color.blue = 0;

                                               
                     for(uint16_t i = 0; i < LED_COUNT; i++)
                     {
                     colors[i] = color;
                     }

                        ledStrip.write(colors, LED_COUNT);  
                        wait_ms (100);
                     }
                                
                else{
                    
                     rgb_color  colors[LED_COUNT]={};
                     ledStrip.write(colors, LED_COUNT);
                     
                     }
       

    }

}
