#include "mbed.h"
#include "EthernetInterface.h"
 
#define MBED_DEV_IP       "192.168.0.52"
#define MBED_DEV_MASK     "255.255.255.0"
#define MBED_DEV_GW       "0.0.0.0"
#define ECHO_SERVER_PORT   80

Serial pc(USBTX, USBRX); // Debug via USB port.
DigitalOut red_led(LED_RED, 1);
DigitalOut green_led(LED_GREEN, 1);

char find_green[50] = "GET /demo_form.asp?LED_COLOUR=GREEN";
char find_red[50] = "GET /demo_form.asp?LED_COLOUR=RED";

int main (void) {
    
    pc.printf("\nHello!\n\r");
    //pc.baud(9600);
    EthernetInterface eth; // Interface using Ethernet to connect to an IP-based network.
    eth.init(); // Initialize the interface with DHCP.
    //eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); // Initialize the interface with a static IP address.
    eth.connect(); // Connect Bring the interface up, start DHCP if needed (Dynamic Host Configuration Protocol).
    
    pc.printf("\nIP Address is %s\n\r", eth.getIPAddress());
    
    TCPSocketServer server; // Instantiate a TCP Server.
    server.bind(ECHO_SERVER_PORT); // Bind a socket to a specific port (80 = HTTP).
    server.listen(); // Start listening for incoming connections.
    
    while (true) {
        pc.printf("\nWait for new connection...\n\r");
        TCPSocketConnection client; //  TCP socket connection.
        server.accept(client); // Accept a new connection.
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        pc.printf("\nConnection from: %s\n\r", client.get_address());
        
        char buffer[600];
        int ret;
        
        /////////////GET//////////////
        while (true) {
            ret = client.receive(buffer, sizeof(buffer)-1); // Receive data from the remote host. 
            if (ret <= 0)break;
            buffer[ret] = '\0';
            printf("Received %d chars from server:\n\r%s\n\r", ret, buffer);
            
            // LED colour seeking:
            if(strstr(buffer, find_red)>0) {
                red_led=0;
                green_led=1;
            }
            if(strstr(buffer, find_green)>0) {
                red_led=1;
                green_led=0;
            }
        }        
        /////////////SET//////////////
        // Webpage here:
        
        char http_cmd[] = "<!DOCTYPE html> <html> <head> <title> FRDM-K64F </title> </head> <body> <h1> Hello World! </h1> <p> LED </p><form action=""demo_form.asp""><SELECT NAME=""LED_COLOUR""> <OPTION VALUE=""""> <OPTION VALUE=""GREEN"">GREEN <OPTION VALUE=""RED"">RED <input type=""submit"" value=""Submit""> </SELECT></form></body> </html>"; 
/*
<!DOCTYPE html>
<html>
    <head>
        <title> FRDM-K64F </title>
    </head>
    <body> 
    
        <h1> Hello World! </h1> 
        <p> LED </p>
        
        <form action="demo_form.asp">
            <SELECT NAME="LED_COLOUR"> 
            <OPTION VALUE="">
            <OPTION VALUE="GREEN">
            GREEN
            <OPTION VALUE="RED">
            RED 
            <input type="submit" value="Submit"> 
            </SELECT>
        </form>
    
    </body>
</html>"; 
*/
        client.send_all(http_cmd, sizeof(http_cmd)-1); // Send all the data to the remote host. 
                
        client.close(); //  Close the socket.
        pc.printf("\n\nClient closed\n\n\r");
     }
}