#ifndef MBED_M702_H
#define MBED_M702_H
#include "mbed.h"

#define sys1 0x01;

void abc();

/*-------------------------------------------------------- 
 Data field module -> host 
---------------------------------------------------------*/ 
#define ID_RESET 0x01 
#define ID_COM_STS 0x02 
#define ID_SELFTEST 0x03 
#define ID_CMD_ACK 0x04 
#define ID_ECGWAVE 0x05 
#define ID_LEAD_STS 0x06 
#define ID_HR 0x07 
#define ID_ST 0x0B 
#define ID_ST_PATTERN 0x0C 
#define ID_RESPWAVE 0x10 
#define ID_RR 0x11 
#define ID_APNEA 0x12 
#define ID_CVA 0x13 
#define ID_TEMP 0x15 
#define ID_SPO2_WAVE 0x16 
#define ID_SPO2_PR 0x17 
#define ID_IBP_WAVE 0x18
#define ID_IBP_STS 0x19 
#define ID_IBP_DATA 0x1A 
#define ID_IBP_CAL 0x1B 
#define ID_IBP_CAL_TIME 0x1C 
#define ID_NBP_CUFPRE 0x20 
#define ID_NBP_END 0x21 
#define ID_NBP_RESULT1 0x22 
#define ID_NBP_RESULT2 0x23 
#define ID_NBP_STS 0x24 
/*-------------------------------------------------------- 
 Data field host -> module 
---------------------------------------------------------*/ 
#define CMD_GET_POST_RESULT 0x40 
#define CMD_PAT_TYPE 0x42 
#define CMD_LEADSYSTEM 0x45 
#define CMD_LEADTYPE 0x46 
#define CMD_FILTER_MODE 0x47 
#define CMD_ECG_GAIN 0x48 
#define CMD_ECG_CAL 0x49 
#define CMD_ECG_TRAP 0x4A 
#define CMD_ID_PACE 0x4B 
#define CMD_ST_ISO 0x4C 
#define CMD_ECG_CHANNEL 0x4D 
#define CMD_ECG_LEARN 0x4E 
#define CMD_RESP_GAIN 0x50 
#define CMD_RESP_THRESHOLD 0x51 //呼吸阀值 新增加
#define CMD_APNEA_ALM 0x52 
#define CMD_TEMP_TYPE 0x53 
#define CMD_SPO2 0x54 
#define CMD_NBP_START 0x55 
#define CMD_NBP_END 0x56 
#define CMD_NBP_PERIOD 0x57 
#define CMD_NBP_CAL 0x58 
#define CMD_NBP_RESET 0x59 
#define CMD_NBP_PNEUMATIC 0x5A 
#define CMD_NBP_POLL_STATE 0x5B 
#define CMD_NBP_PRE_PRESSURE 0x5C 
#define CMD_NBP_CONTINUE 0x5D 
#define CMD_NBP_GET_RESULT 0x5E 
#define CMD_NIBP_FACTROYCAL 0x5F //厂家校准
#define CMD_IBP_CHANNEL 0x60 
#define CMD_IBP_ZERO 0x61 
#define CMD_IBP_CAL1 0x62 
#define CMD_IBP_CAL2 0x63 
#define CMD_IBP_FILTER 0x64
#define CMD_IBP_POLL_STATE 0x65


char gPackLength[128] = 
{ 
0 , // 00: 保留 
2 , // 01: 系统复位信息
5 , // 02: 系统状态
9 , // 03: 系统自检 
5 , // 04: 命令应答
8 , // 05: ECG 波形数据
5 , // 06: 导联连接和信号信息
5 , // 07: 心率 
0 , // 08: 保留 
0 , // 09: 保留 
0 , // 0a: 保留 
7 , // 0b: ST 偏移 
9 , // 0c: ST 段波形值
0 , // 0d: 保留 
0 , // 0e: 保留
0, // 0f: 保留
4, // 10: 呼吸波
5, // 11: 呼吸率
6, // 12: 窒息报警
4, // 13: CVA 报警信息
0, // 14: 保留
8, // 15: 体温数据
5, // 16: SPO2 波形数据
7, // 17: SPO2 数据
7, // 18: IBP 波形数据
4, // 19: IBP 状态
10, // 1a: IBP 压力
6, // 1b: IBP 校零和校准信息
7, // 1c: IBP 校零和校准时间
0, // 1d: 保留
0, // 1e: 保留
0, // 1f: 保留
7, // 20: NBP 实时测量数据
4, // 21: NBP 测量结束包
9, // 22: NBP 测量结果 1 
5, // 23: NBP 测量结果 2 
8, // 24: NBP 测量状态
0, // 25: 保留
0, // 26: 保留
0, // 27: 保留
0, // 28: 保留
0, // 29: 保留
0, // 2a: 保留
0, // 2b: 保留
0, // 2c: 保留
0, // 2d: 保留
0, // 2e: 保留
0, // 2f: 保留
0, // 30: 保留
0, // 31: 保留
0, // 32: 保留
0, // 33: 保留
0, // 34: 保留
0, // 35: 保留
0, // 36: 保留
0, // 37: 保留
0, // 38: 保留
0, // 39: 保留
0, // 3a: 保留
0, // 3b: 保留
0, // 3c: 保留
0, // 3d: 保留
0, // 3e: 保留
0, // 3f: 保留
2, // 40: 读取自检结果
4, // 41: 接收数据选择
4, // 42: 病人信息设置
0, // 43: 保留
0, // 44: 保留
4, // 45: 导联模式选择:3,5 导
4, // 46: 导联方式选择
4, // 47: 滤波方式选择
4, // 48: 心电增益
4, // 49: 1mV 校准信号设置
4, // 4a: 工频抑制设置
4, // 4b: 起搏分析开关设置
7, // 4c: ST 测量的 ISO 和 ST 点
4, // 4d: 设置心电分析通道
2, // 4e: 心电自学习触发
0, // 4f: 保留
4, // 50: 呼吸增益
0, // 51: 保留
4, // 52: 窒息报警时间选择
4, // 53: 体温探头类型设置 
4, // 54: SPO2 设置
2, // 55: NBP 开始一次手动/自动测量
2, // 56: NBP 结束测量
4, // 57: NBP 测量周期设置
2, // 58: NBP 开始校准
2, // 59: NBP 复位
2, // 5a: NBP 漏气检测
2, // 5b: NBP 查询状态
5, // 5c: NBP 设置初次充气压力
2, // 5d: NBP 开始 STAT 测量
2, // 5e: NBP 查询结果
0, // 5f: 保留
4, // 60: IBP 设置压力名称
4, // 61: IBP 校零
7, // 62: IBP1 校准
7, // 63: IBP2 校准
4, // 64: 设置数字滤波模式
5, // 65: IBP 查询
0, // 66: 保留
0, // 67: 保留
0, // 68: 保留
0, // 69: 保留
0, // 6a: 保留
0, // 6b: 保留
0, // 6c: 保留
0, // 6d: 保留
0, // 6e: 保留
0, // 6f: 保留
0, // 70: 保留
0, // 71: 保留
0, // 72: 保留
0, // 73: 保留
0, // 74: 保留
0, // 75: 保留
0, // 76: 保留
0, // 77: 保留
0, // 78: 保留
0, // 79: 保留
0, // 7a: 保留
0, // 7b: 保留
0, // 7c: 保留
0, // 7d: 保留
0, // 7e: 保留
0, // 7f: 保留
};



#endif


