#include "mbed.h"
#include <VS1053.h>
#include"SDFileSystem.h"

VS1053 player(D11, D12, D13, D6, D7, D2, D8);//mosi,miso,sclk,xcs,xdcs,dreq,xreset

SDFileSystem sd(D11, D12, D13, D9, "sd"); // the pinout on the mbed Cool

static unsigned char fileBuf[1024];
unsigned char *bufptr;


void playFile(char *file) {
    int bytes;        // How many bytes in buffer left
    
    printf("Current file is %s\n",file);

    FileHandle *fp =sd.open(file, O_RDONLY);
    
    if(fp == NULL) {
        printf("Could not open %s\r\n",file);
    }
    else
    {
        printf("Playing %s ...\r\n",file);
        
        /* Main playback loop */
        while((bytes = fp->read(fileBuf,1)) > 0)
        {
            bufptr = fileBuf;
            player.sendDataBlock(bufptr, bytes);
        }
    }
}

Serial com(USBTX, USBRX); //Initiallize the Serial Port 0 (9600 bits/sec)

int main() {
    com.printf("VS1053 Hello World\n");
    player.hardwareReset(); //Make a reset to the VS1053 board
    player.modeSwitch();    //Patch the VS1054 board to play MP3 files (very important!).
    while(1) { //Do that loop forever
        playFile("track001.mp3");wait(1);
        playFile("track002.mp3");wait(1);
        playFile("track003.mp3");wait(1);
        playFile("track004.mp3");wait(1);
        playFile("track005.mp3");wait(1);
        playFile("track006.mp3");wait(1);
        playFile("track007.mp3");wait(1);
        playFile("track008.mp3");wait(1);
    }
}