#if 0
/*
 * mbed Application program
 *      SD-Card Control Program
 *
 *  Copyright (c) 2010-2014 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      March   28th, 2010  Started
 *      April    3rd, 2010
 *      October  3rd, 2014  use latest lib.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
//-------------------------------------------------------------------------------------------------
// Function
//      5 channeles ADC data records into a file which is located in SD-Card
//      If USE_LCD = 1, data shows on a Text LCD
//      If USE_RTC = 1, time stamp also writes in the file
// Connection
//      Analog input    PIN 15,16,17,19,20
//      LCD             PIN 22,21,8,7,6,5
//       -> CAUTION!! pin assignment is different
//          with " http://mbed.org/projects/cookbook/wiki/TextLCD "
//      RTC             PIN 3 needs to connect 3V Battery
//       -> Please refer my program " RTC_w_COM" for time adjustment
//          at " http://mbed.org/users/kenjiArai/programs/RTC_w_COM/5yi9a/ "
//-------------------------------------------------------------------------------------------------
 
//  Include ---------------------------------------------------------------------------------------
#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
 
//  Definition ------------------------------------------------------------------------------------
#define DEBUG       1           // 1= Shows progress on PC via USB ( virtual COM line)
#define USE_LCD     1           // 1= Display the data on LCD
#define USE_RTC     1           // 1= Use RTC (need 3V supply and time adjustment before use)
 
#define NO_OF_SAMPLE    100     // Total recording length -> unit=sec
#define TIM_INTVL       10      // Insert time stamp in the file every ?? sec
 
//  Object ----------------------------------------------------------------------------------------
DigitalOut myled(LED1);         // Indicate the sampling period
#if USE_LCD
TextLCD lcd(p22, p21, p8, p7, p6, p5, TextLCD::LCD40x2);  // rs, e, d4-d7
#endif
AnalogIn ain_G_X(p15);          // G Sensor
AnalogIn ain_G_Y(p16);          // G Sensor
AnalogIn ain_G_Z(p17);          // G Sensor
AnalogIn ain_BAT(p19);          // Battery Volt
AnalogIn ain_TEMP(p20);         // Temperature Sensor
SDFileSystem sd(p11, p12, p13, p14, "sd");  // do,di,clk,cs
#if DEBUG
Serial pc(USBTX, USBRX);
#endif
 
//  RAM -------------------------------------------------------------------------------------------
 
//  ROM / Constant data ---------------------------------------------------------------------------
 
//  Function prototypes ---------------------------------------------------------------------------
 
//-------------------------------------------------------------------------------------------------
//  Control Program
//-------------------------------------------------------------------------------------------------
int main()
{
    char buf[40];               // data buffer for text
    int count;                  // count for number of record
    float x,y,z,b,t;            // Analog data
#if USE_RTC
    time_t seconds, old_sec;    // RTC data based on seconds
    int i;
#endif
 
    // Open the file
#if USE_RTC
    seconds = time(NULL);
    seconds %= 100000000;               // Adjust 8 charcters file name
    sprintf(buf,"/sd/%d.txt",seconds);  // File name is defined based on time from 1970/1/1
    FILE *fp = fopen(buf, "w");         // Open "out.txt" on the local file system for writing
#if DEBUG
    printf("\r\n %s \r\n", buf);        // File name on the screen
    printf(" use RTC\r\n");
#endif
#else
    FILE *fp = fopen("/sd/out.txt", "w");// Open "out.txt" on the local file system for writing
#if DEBUG
    printf("\r\n /sd/out.txt\r\n");     // File name on the screen
    printf(" Not use RTC\r\n");
#endif
#endif
    if(fp == NULL) {
        // File not open and stop
#if USE_LCD
        lcd.printf("  Could not open file for write\n");
#endif
#if DEBUG
        printf( "\r\n Could not open file for write\r\n");
#endif
        while(1) ;
    }
    // Success file access
    fprintf(fp, "This is a test program for logging /by JH1PJL\r\n");
#if DEBUG
    printf(     "This is a test program for logging /by JH1PJL\r\n");
    printf("\r\nStart sampling\r\n");
#endif
#if USE_LCD
    lcd.cls();
#endif
 
    count = 0;              // Initialze counter
#if USE_RTC
    seconds = time(NULL);   // Put time stamp in the file
    old_sec = seconds;
    strftime(buf,40, "Time:%I:%M:%S %p, %Y/%m/%d\r\n", localtime(&seconds));
    fprintf(fp,buf);
#if DEBUG
    printf("  %s \r\n", buf);
#endif
#endif
    while(1) {
        // check time interval (1sec)
#if USE_RTC
        myled = 1;
        wait(0.5);
        myled = 0;
        while ((seconds = time(NULL)) == old_sec) ;    // Wait 1 sec for loop
        old_sec = seconds;
#else
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
#endif
        // Get analog data from each port
        x=ain_G_X.read();
        y=ain_G_Y.read();
        z=ain_G_Z.read();
        b=ain_BAT.read();
        t=ain_TEMP.read();
        // Write data into the file
        sprintf(buf, "G-Sen, %f, %f, %f  \r\n", x, y, z);
        fprintf(fp,buf);
#if USE_LCD
        lcd.locate(0, 0);   // 1st line top
        lcd.printf(buf);
#endif
#if DEBUG
        printf(" %s", buf);
#endif
        sprintf(buf, "VB, %f, T, %f  \r\n", b, t);
        fprintf(fp,buf);
#if USE_LCD
        lcd.locate(0, 1);   // 2nd line top
        lcd.printf(buf);
#endif
#if DEBUG
        printf(" %s", buf);
#endif
        // if reach to expected data number then finsh
        if (++count > NO_OF_SAMPLE) {
            break;
        }
        // Set time satmp
#if USE_RTC
        i = count / TIM_INTVL;
        if (count == i * TIM_INTVL) {
            //seconds = time(NULL);     // this line is wrong! BUG
            strftime(buf,40, "Time:%I:%M:%S %p, %Y/%m/%d\r\n", localtime(&seconds));
            fprintf(fp, buf);
#if DEBUG
            printf(" %s", buf);
#endif
        }
#endif
#if DEBUG
        printf("Sampling #%d/end=%d\r\n", count, NO_OF_SAMPLE);
#endif
    }
    // Set time satmp
#if USE_RTC
    sprintf(buf,"Sampling numbers: %d\r\n", count-1);
    fprintf(fp, buf);
    seconds = time(NULL);
    strftime(buf,40, "Time:%I:%M:%S %p, %Y/%m/%d\r\n", localtime(&seconds));
    fprintf(fp, buf);
#if DEBUG
    printf(" %s", buf);
#endif
#endif
    fclose(fp);
    // for debug
#if DEBUG
    printf("\r\nFinished sampling\r\n");
#endif
}
#endif
